/*
 * Decompiled with CFR 0.152.
 */
package cn.vika.client.api;

import cn.vika.client.api.exception.ApiException;
import cn.vika.client.api.http.AbstractApi;
import cn.vika.client.api.http.ApiHttpClient;
import cn.vika.client.api.model.Attachment;
import cn.vika.client.api.model.HttpResult;
import cn.vika.core.http.FormDataMap;
import cn.vika.core.http.GenericTypeReference;
import cn.vika.core.http.HttpHeader;
import cn.vika.core.http.ResourceLoader;
import cn.vika.core.utils.AssertUtil;
import java.io.File;

public class AttachmentApi
extends AbstractApi {
    private static final String PATH = "/datasheets/%s/attachments";

    public AttachmentApi(ApiHttpClient apiHttpClient) {
        super(apiHttpClient);
    }

    public Attachment upload(String datasheetId, ResourceLoader loader) throws ApiException {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.setContentType("multipart/form-data");
        FormDataMap formDataMap = new FormDataMap();
        formDataMap.put((Object)"file", (Object)loader);
        HttpResult result = (HttpResult)this.getDefaultHttpClient().post(String.format(PATH, datasheetId), httpHeader, (Object)formDataMap, (GenericTypeReference)new GenericTypeReference<HttpResult<Attachment>>(){}, new Object[0]);
        return (Attachment)result.getData();
    }

    public Attachment upload(String datasheetId, File file) throws ApiException {
        AssertUtil.notNull((Object)file, (String)"file can not be null");
        FormDataMap formDataMap = new FormDataMap();
        formDataMap.put((Object)"file", (Object)file);
        return this.upload(datasheetId, formDataMap);
    }

    public Attachment upload(String datasheetId, FormDataMap formData) throws ApiException {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.setContentType("multipart/form-data");
        HttpResult result = (HttpResult)this.getDefaultHttpClient().post(String.format(PATH, datasheetId), httpHeader, (Object)formData, (GenericTypeReference)new GenericTypeReference<HttpResult<Attachment>>(){}, new Object[0]);
        return (Attachment)result.getData();
    }
}

