/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.toolkit;

import io.horizon.eon.em.typed.ChangeFlag;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.atom.runtime.WRecord;
import io.vertx.tp.workflow.atom.runtime.WRequest;
import io.vertx.tp.workflow.atom.runtime.WTransition;
import io.vertx.tp.workflow.plugin.activity.ActivityTabb;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.sectio.Around;
import io.vertx.up.uca.sectio.Aspect;
import io.vertx.up.uca.sectio.AspectConfig;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.camunda.bpm.engine.task.Task;

public class UTracker {
    private final transient MetaInstance metadata;

    public UTracker(MetaInstance metadata) {
        this.metadata = metadata;
    }

    public Future<WRequest> beforeAsync(WRequest request, WTransition transition) {
        Aspect aspect = this.aspect(transition);
        return ((Future)aspect.wrapJBefore(Around.TYPE_ALL.toArray(new ChangeFlag[0])).apply(request.request())).compose(request::future);
    }

    public Future<WRecord> afterAsync(WRecord record, WTransition transition) {
        Aspect aspect = this.aspect(transition);
        JsonArray todo = record.dataAop();
        if (Ut.isNil((JsonArray)todo)) {
            return Ux.future((Object)record);
        }
        if (1 == todo.size()) {
            JsonObject input = todo.getJsonObject(0);
            Task task = transition.from();
            return ((Future)aspect.wrapJAfter(Around.TYPE_ALL.toArray(new ChangeFlag[0])).apply(this.aspectParameter(input, task))).compose(record::futureAfter);
        }
        ArrayList runner = new ArrayList();
        Ut.itJArray((JsonArray)todo).forEach(json -> {
            Future future = (Future)aspect.wrapJAfter(Around.TYPE_ALL.toArray(new ChangeFlag[0])).apply(json);
            runner.add(future);
        });
        return Fn.combineA(runner).compose(nil -> Ux.future((Object)record));
    }

    private JsonObject aspectParameter(JsonObject parameters, Task task) {
        if (Objects.nonNull(task)) {
            parameters.put("taskName", (Object)task.getName());
        }
        return parameters;
    }

    private Aspect aspect(WTransition transition) {
        AspectConfig aspectConfig = transition.aspect();
        List afterList = aspectConfig.nameAfter();
        if (!afterList.contains(ActivityTabb.class)) {
            afterList.add(ActivityTabb.class);
            JsonObject config = new JsonObject();
            config.put("auditor", (Object)this.metadata.childAuditor());
            aspectConfig.config(ActivityTabb.class, config);
        }
        Wf.LOG.Web.info(this.getClass(), "Aspect Config: {0}", new Object[]{aspectConfig.toString()});
        return Aspect.create((AspectConfig)aspectConfig);
    }
}

