/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.toolkit;

import cn.vertxup.workflow.domain.tables.daos.WTicketDao;
import cn.vertxup.workflow.domain.tables.daos.WTodoDao;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.atom.runtime.WRecord;
import io.vertx.tp.workflow.atom.runtime.WTransition;
import io.vertx.tp.workflow.uca.ticket.Sync;
import io.vertx.tp.workflow.uca.toolkit.UTL;
import io.vertx.up.atom.Refer;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class UTicket {
    private final transient MetaInstance metadata;

    public UTicket(MetaInstance metadata) {
        this.metadata = metadata;
    }

    public Future<WRecord> generateAsync(JsonObject requestJ, WTransition wTransition, WRecord record) {
        WTicket ticket = record.ticket();
        Objects.requireNonNull(ticket);
        WRecord generatedNew = UTL.recordU(wTransition);
        return UTL.beforeGenerate(record, generatedNew).compose(generated -> Ux.Jooq.on(WTicketDao.class).fetchByIdAsync((Object)ticket.getKey()).compose(processed -> Sync.ticket(this.metadata).treatAsync(requestJ, (WRecord)generated, (WTicket)processed)).compose(recordRef -> Sync.extension(this.metadata).treatAsync(requestJ, (WRecord)recordRef)).compose(nil -> UTL.beforeUpdate(generated, record.task(), requestJ)).compose(nil -> {
            WTodo todo = record.task();
            JsonObject todoJ = Ux.toJson((Object)todo);
            todoJ.mergeIn(requestJ, true);
            return wTransition.end(todoJ, generated.ticket(), todo);
        }).compose(arg_0 -> ((UxJooq)Ux.Jooq.on(WTodoDao.class)).insertAsync(arg_0)).compose(tasks -> UTL.afterUpdate(tasks, generated)));
    }

    public Future<WRecord> insertAsync(JsonObject params, WTransition wTransition) {
        return this.insertTicket(params, wTransition).compose(record -> {
            WTicket inserted = record.ticket();
            JsonObject gearInput = params.copy();
            return wTransition.end(gearInput, inserted).compose(arg_0 -> ((UxJooq)Ux.Jooq.on(WTodoDao.class)).insertAsync(arg_0)).compose(tasks -> UTL.afterUpdate(tasks, record));
        });
    }

    public Future<WRecord> saveAsync(JsonObject params, WTransition wTransition) {
        JsonObject ticketJson = params.copy();
        String tKey = ticketJson.getString("traceId");
        UxJooq tJq = Ux.Jooq.on(WTicketDao.class);
        return tJq.fetchByIdAsync((Object)tKey).compose(ticket -> {
            if (Objects.isNull(ticket)) {
                return this.insertAsync(params, wTransition);
            }
            WRecord record = UTL.recordU(wTransition);
            return Sync.ticket(this.metadata).treatAsync(params, record, (WTicket)ticket).compose(recordRef -> Sync.extension(this.metadata).treatAsync(params, (WRecord)recordRef)).compose(processed -> Sync.task(this.metadata).treatAsync(params, (WRecord)processed));
        });
    }

    public Future<WRecord> updateAsync(JsonObject params, WTransition wTransition) {
        String tKey = params.getString("traceId");
        WRecord record = UTL.recordU(wTransition);
        return Ux.Jooq.on(WTicketDao.class).fetchByIdAsync((Object)tKey).compose(processed -> Sync.ticket(this.metadata).treatAsync(params, record, (WTicket)processed)).compose(recordRef -> Sync.extension(this.metadata).treatAsync(params, (WRecord)recordRef)).compose(processed -> Sync.task(this.metadata).treatAsync(params, (WRecord)processed));
    }

    private Future<WRecord> insertTicket(JsonObject params, WTransition wTransition) {
        Refer refer = new Refer();
        return this.metadata.todoInitialize(params).compose(arg_0 -> ((Refer)refer).future(arg_0)).compose(normalized -> {
            JsonObject ticketJ = normalized.copy();
            ticketJ.remove("key");
            WTicket ticket = (WTicket)Ux.fromJson((JsonObject)ticketJ, WTicket.class);
            ticket.setKey(normalized.getString("traceKey"));
            ticket.setFlowEnd(Boolean.FALSE);
            ProcessInstance instance = wTransition.instance();
            ticket.setFlowInstanceId(instance.getId());
            return Ux.Jooq.on(WTicketDao.class).insertAsync((Object)ticket);
        }).compose(ticket -> UTL.afterInsert(ticket, wTransition)).compose(recordRef -> Sync.extension(this.metadata).treatAsync((JsonObject)refer.get(), (WRecord)recordRef));
    }
}

