/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.toolkit;

import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import io.horizon.eon.em.typed.ChangeFlag;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.runtime.WRecord;
import io.vertx.tp.workflow.atom.runtime.WTransition;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;

public class UTL {
    public static WRecord recordU(WTransition transition) {
        return WRecord.create(true, ChangeFlag.UPDATE).bind(transition.vague());
    }

    public static WRecord recordA(WTransition transition) {
        return WRecord.create(true, ChangeFlag.ADD).bind(transition.vague());
    }

    public static Future<WRecord> afterInsert(WTicket ticket, WTransition transition) {
        WRecord record = UTL.recordA(transition);
        record.ticket(ticket);
        return Ux.future((Object)record);
    }

    public static Future<WRecord> beforeUpdate(WRecord generated, WTodo todo, JsonObject requestJ) {
        WRecord prev = generated.prev();
        if (Objects.nonNull(prev)) {
            prev.task(todo);
        }
        if (Ut.isNotNil((JsonObject)requestJ)) {
            return generated.futureAfter(requestJ);
        }
        return Ux.future((Object)generated);
    }

    public static Future<WRecord> beforeGenerate(WRecord record, WRecord generated) {
        WRecord prev = record.prev();
        if (Objects.isNull(prev)) {
            generated.prev(record);
        } else {
            generated.prev(prev);
        }
        return Ux.future((Object)generated);
    }

    public static Future<WRecord> beforeUpdate(JsonObject ticketJ, WRecord queried) {
        Objects.requireNonNull(ticketJ);
        WRecord prev = queried.prev();
        if (Objects.nonNull(prev) && Ut.isNil((JsonObject)prev.child())) {
            prev.ticket(ticketJ.copy());
        }
        return Ux.future((Object)queried);
    }

    public static Future<WRecord> beforeUpdate(WTicket ticketIn, WRecord queried) {
        Objects.requireNonNull(queried.prev());
        WRecord prev = queried.prev();
        if (Objects.isNull(prev.ticket())) {
            prev.ticket(new WTicket(ticketIn));
        }
        return Ux.future((Object)queried);
    }

    public static Future<WRecord> beforeUpdate(WTodo todoIn, WRecord record) {
        Objects.requireNonNull(todoIn);
        WRecord prev = record.prev();
        if (Objects.nonNull(prev) && Objects.isNull(prev.task())) {
            prev.task(new WTodo(todoIn));
        }
        return Ux.future((Object)record);
    }

    public static Future<WRecord> afterUpdate(WTicket ticket, WRecord current) {
        current.ticket(ticket);
        return Ux.future((Object)current);
    }

    public static Future<WRecord> afterUpdate(JsonObject ticketJ, WRecord current) {
        current.ticket(ticketJ);
        return Ux.future((Object)current);
    }

    public static Future<WRecord> afterUpdate(WTodo todo, WRecord current) {
        current.task(todo);
        return Ux.future((Object)current);
    }

    public static Future<WRecord> afterUpdate(List<WTodo> todos, WRecord current) {
        current.task(todos);
        return Ux.future((Object)current);
    }

    public static Future<WRecord> afterGenerate(List<WTodo> todos, WRecord current) {
        return UTL.afterUpdate(todos, current);
    }
}

