/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.toolkit;

import cn.vertxup.workflow.cv.em.TodoStatus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.runtime.WTransition;
import io.vertx.tp.workflow.uca.conformity.GVm;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.camunda.bpm.engine.task.Task;

public class URequest {
    public static void reduceJ(JsonObject dataJ) {
        dataJ.remove("key");
        dataJ.remove("serial");
        dataJ.remove("code");
        dataJ.remove("createdBy");
        dataJ.remove("createdAt");
        dataJ.remove("sigma");
        dataJ.remove("language");
        dataJ.remove("metadata");
        dataJ.remove("flowDefinitionKey");
        dataJ.remove("flowDefinitionId");
        dataJ.remove("flowInstanceId");
        dataJ.remove("taskKey");
        dataJ.remove("taskId");
        Object toUser = dataJ.getValue("toUser");
        if (toUser instanceof JsonArray || toUser instanceof JsonObject) {
            dataJ.remove("toUser");
        }
    }

    public static JsonObject inputJ(JsonObject params) {
        if (!params.containsKey("key")) {
            params.put("key", (Object)UUID.randomUUID().toString());
        }
        if (!params.containsKey("traceKey")) {
            params.put("traceKey", (Object)UUID.randomUUID().toString());
        }
        return params;
    }

    public static String inputJ(JsonObject params, JsonObject record, boolean isObject) {
        String recordKey;
        if (record.containsKey("key")) {
            recordKey = record.getString("key");
        } else {
            recordKey = UUID.randomUUID().toString();
            record.put("key", (Object)recordKey);
        }
        if (isObject) {
            params.put("modelKey", (Object)recordKey);
        }
        record.put("modelKey", params.getValue("traceKey"));
        return recordKey;
    }

    public static JsonObject closeJ(JsonObject params, WTransition wTransition) {
        JsonObject updatedData = params.copy();
        GVm.finish(updatedData, wTransition);
        String user = params.getString("updatedBy");
        updatedData.put("finishedAt", (Object)Instant.now());
        updatedData.put("finishedBy", (Object)user);
        updatedData.put("active", (Object)Boolean.TRUE);
        if (wTransition.isEnded()) {
            updatedData.put("flowEnd", (Object)Boolean.TRUE);
            updatedData.put("closeAt", (Object)Instant.now());
            updatedData.put("closeBy", (Object)user);
        }
        return updatedData;
    }

    public static JsonObject cancelJ(JsonObject params, WTransition wTransition, Set<String> historySet) {
        return URequest.endJ(params, wTransition, historySet, TodoStatus.CANCELED);
    }

    public static JsonObject closeJ(JsonObject params, WTransition wTransition, Set<String> historySet) {
        return URequest.endJ(params, wTransition, historySet, TodoStatus.FINISHED);
    }

    private static JsonObject endJ(JsonObject params, WTransition wTransition, Set<String> historySet, TodoStatus status) {
        JsonObject todoData = params.copy();
        String user = todoData.getString("updatedBy");
        HashSet<String> traceSet = new HashSet<String>(historySet);
        Task task = wTransition.from();
        if (Objects.nonNull(task)) {
            traceSet.add(task.getTaskDefinitionKey());
        }
        JsonObject history = new JsonObject();
        history.put("history", (Object)Ut.toJArray(traceSet));
        todoData.put("status", (Object)status.name());
        todoData.put("finishedAt", (Object)Instant.now());
        todoData.put("finishedBy", (Object)user);
        todoData.put("flowEnd", (Object)Boolean.TRUE);
        if (TodoStatus.CANCELED == status) {
            todoData.put("cancelAt", (Object)Instant.now());
            todoData.put("cancelBy", (Object)user);
        }
        if (TodoStatus.FINISHED == status) {
            todoData.put("closeAt", (Object)Instant.now());
            todoData.put("closeBy", (Object)user);
        }
        return todoData;
    }
}

