/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.toolkit;

import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.EngineOn;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.atom.runtime.WRecord;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.modeling.Respect;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ULinkage {
    private final transient MetaInstance metadata;

    public ULinkage(MetaInstance metadata) {
        this.metadata = metadata;
    }

    private ULinkage(WRecord record) {
        WTicket ticket = record.ticket();
        Objects.requireNonNull(ticket);
        EngineOn engine = EngineOn.connect(ticket.getFlowDefinitionKey());
        this.metadata = engine.metadata();
    }

    public static Future<WRecord> readLinkage(WRecord record) {
        ULinkage helper = new ULinkage(record);
        return helper.fetchAsync(record);
    }

    private Future<WRecord> fetchAsync(WRecord record) {
        if (this.metadata.linkSkip()) {
            return Ux.future((Object)record);
        }
        ConcurrentHashMap futures = new ConcurrentHashMap();
        Set<String> fields = this.metadata.linkFields();
        Wf.LOG.Web.info(this.getClass(), "( Fetch ) Linkage Definition Size: {0}", new Object[]{fields.size()});
        fields.forEach(field -> {
            Respect respect = this.metadata.linkRespect((String)field);
            futures.put(field, respect.fetchAsync(record));
        });
        return Fn.combineM(futures).compose(dataMap -> {
            dataMap.forEach(record::linkage);
            return Ux.future((Object)record);
        });
    }

    public Future<WRecord> syncAsync(JsonObject params, WRecord record) {
        WRecord prev = record.prev();
        if (Objects.nonNull(prev) && prev.data().size() > 0) {
            return this.fetchAsync(prev).compose(prevRecord -> {
                record.prev((WRecord)prevRecord);
                return this.syncAsyncInternal(params, record);
            });
        }
        return this.syncAsyncInternal(params, record);
    }

    private Future<WRecord> syncAsyncInternal(JsonObject params, WRecord record) {
        WTicket ticket = record.ticket();
        if (Objects.isNull(ticket) || this.metadata.linkSkip()) {
            return Ux.future((Object)record);
        }
        ConcurrentHashMap futures = new ConcurrentHashMap();
        Set<String> fields = this.metadata.linkFields();
        Wf.LOG.Web.info(this.getClass(), "( Sync ) Linkage Definition Size: {0}", new Object[]{fields.size()});
        fields.forEach(field -> {
            JsonArray linkageData = Ut.valueJArray((JsonObject)params, (String)field);
            Respect respect = this.metadata.linkRespect((String)field);
            futures.put(field, respect.syncAsync(linkageData, params, record));
        });
        return Fn.combineM(futures).compose(dataMap -> {
            dataMap.forEach(record::linkage);
            return Ux.future((Object)record);
        });
    }
}

