/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.modeling;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.uca.modeling.AbstractRegister;
import io.vertx.tp.workflow.uca.modeling.ActionOn;
import io.vertx.up.util.Ut;
import java.util.Objects;

public class RegisterJ
extends AbstractRegister {
    @Override
    public Future<JsonObject> insertAsync(JsonObject params, MetaInstance metadata) {
        JsonObject rData = params.getJsonObject("record", new JsonObject());
        ActionOn action = ActionOn.action(metadata.recordMode());
        JsonObject recordData = this.normalize(params, rData, true);
        return Ke.umIndent((JsonObject)recordData, (String)metadata.recordIndent()).compose(processed -> action.createAsync((JsonObject)processed, metadata)).compose(record -> this.outputAsync(params, (JsonObject)record));
    }

    @Override
    public Future<JsonObject> updateAsync(JsonObject params, MetaInstance metadata) {
        JsonObject rData = params.getJsonObject("record", new JsonObject());
        ActionOn action = ActionOn.action(metadata.recordMode());
        JsonObject recordData = this.normalize(params, rData, false);
        String key = metadata.recordKeyU(recordData);
        return action.updateAsync(key, recordData, metadata).compose(record -> this.outputAsync(params, (JsonObject)record));
    }

    @Override
    public Future<JsonObject> saveAsync(JsonObject params, MetaInstance metadata) {
        JsonObject rData = params.getJsonObject("record", new JsonObject());
        ActionOn action = ActionOn.action(metadata.recordMode());
        JsonObject recordData = this.normalize(params, rData, true);
        String key = metadata.recordKeyU(recordData);
        Objects.requireNonNull(key);
        String identifier = rData.getString("identifier");
        return action.fetchAsync(key, identifier, metadata).compose(queried -> {
            if (Ut.isNil((JsonObject)queried)) {
                return action.createAsync(recordData, metadata);
            }
            recordData.remove("createdAt");
            recordData.remove("createdBy");
            return action.updateAsync(key, recordData, metadata);
        }).compose(record -> this.outputAsync(params, (JsonObject)record));
    }
}

