/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.conformity;

import cn.vertxup.workflow.cv.em.PassWay;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.runtime.WTask;
import io.vertx.tp.workflow.uca.conformity.AbstractGear;
import io.vertx.tp.workflow.uca.conformity.Gain;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.engine.task.Task;

public class GearMulti
extends AbstractGear {
    public GearMulti() {
        super(PassWay.Multi);
    }

    @Override
    public Future<List<WTodo>> todoAsync(JsonObject parameters, WTask wTask, WTicket ticket) {
        List<Task> taskList = wTask.multi();
        if (taskList.isEmpty()) {
            return Ux.futureL();
        }
        ConcurrentMap<String, JsonObject> assignMap = this.buildAssign(parameters, taskList, false);
        ArrayList queue = new ArrayList();
        Gain starter = Gain.starter(ticket);
        taskList.forEach(task -> {
            JsonObject eachData = parameters.copy();
            JsonObject assignData = assignMap.getOrDefault(task.getTaskDefinitionKey(), new JsonObject());
            eachData.mergeIn(assignData, true);
            queue.add(starter.buildAsync(eachData, (Task)task, null));
        });
        return Fn.combineT(queue).compose(generatedQ -> {
            AtomicInteger seed = new AtomicInteger(1);
            generatedQ.forEach(generated -> {
                generated.setSerialFork(null);
                this.buildSerial((WTodo)generated, ticket, seed.getAndIncrement());
            });
            return Ux.future((Object)generatedQ);
        });
    }

    @Override
    public Future<List<WTodo>> todoAsync(JsonObject parameters, WTask wTask, WTicket ticket, WTodo todo) {
        List<Task> taskList = wTask.multi();
        if (taskList.isEmpty()) {
            return Ux.futureL();
        }
        ConcurrentMap<String, JsonObject> assignMap = this.buildAssign(parameters, taskList, true);
        ArrayList queue = new ArrayList();
        Gain generator = Gain.generator(ticket);
        taskList.forEach(task -> {
            JsonObject eachData = parameters.copy();
            JsonObject assignData = assignMap.getOrDefault(task.getTaskDefinitionKey(), new JsonObject());
            eachData.mergeIn(assignData, true);
            queue.add(generator.buildAsync(eachData, (Task)task, todo));
        });
        return Fn.combineT(queue).compose(generatedQ -> {
            AtomicInteger seed = new AtomicInteger(1);
            generatedQ.forEach(generated -> {
                generated.setSerialFork(todo.getSerialFork());
                this.buildSerial((WTodo)generated, ticket, seed.getAndIncrement());
            });
            return Ux.future((Object)generatedQ);
        });
    }

    private ConcurrentMap<String, JsonObject> buildAssign(JsonObject parameters, List<Task> tasks, boolean generation) {
        ConcurrentHashMap<String, JsonObject> response = new ConcurrentHashMap<String, JsonObject>();
        JsonArray toUser = Ut.valueJArray((JsonObject)parameters, (String)"toUser");
        int size = tasks.size();
        Ut.itJArray((JsonArray)toUser, String.class, (userKey, index) -> {
            if (index < size - 1) {
                Task task = (Task)tasks.get((int)index);
                JsonObject value = new JsonObject();
                value.put("taskId", (Object)task.getId());
                value.put("taskKey", (Object)task.getTaskDefinitionKey());
                if (generation) {
                    value.putNull("toUser");
                } else {
                    value.put("toUser", (Object)toUser);
                }
                value.put("acceptedBy", (Object)toUser);
                response.put(task.getTaskDefinitionKey(), value);
            }
        });
        parameters.remove("toUser");
        parameters.remove("acceptedBy");
        return response;
    }
}

