/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.conformity;

import cn.vertxup.workflow.cv.em.PassWay;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.runtime.WTask;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.conformity.AbstractGear;
import io.vertx.tp.workflow.uca.conformity.Gain;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.camunda.bpm.engine.task.Task;

public class GearForkJoin
extends AbstractGear {
    public GearForkJoin() {
        super(PassWay.Fork);
    }

    @Override
    public Future<List<WTodo>> todoAsync(JsonObject parameters, WTask wTask, WTicket ticket) {
        ConcurrentMap<String, Task> taskMap = wTask.fork();
        if (taskMap.isEmpty()) {
            return Ux.futureL();
        }
        ConcurrentMap<String, JsonObject> assignMap = this.buildAssign(parameters, taskMap, false);
        ArrayList queue = new ArrayList();
        Gain starter = Gain.starter(ticket);
        taskMap.forEach((taskKey, task) -> {
            JsonObject eachData = parameters.copy();
            JsonObject assignData = assignMap.getOrDefault(taskKey, new JsonObject());
            eachData.mergeIn(assignData, true);
            queue.add(starter.buildAsync(eachData, (Task)task, null));
        });
        return Fn.combineT(queue).compose(generatedQ -> {
            AtomicInteger seed = new AtomicInteger(1);
            generatedQ.forEach(generated -> {
                generated.setKey(UUID.randomUUID().toString());
                generated.setSerialFork(String.valueOf(seed.getAndIncrement()));
                this.buildSerial((WTodo)generated, ticket, null);
            });
            return Ux.future((Object)generatedQ);
        });
    }

    @Override
    public Future<List<WTodo>> todoAsync(JsonObject parameters, WTask wTask, WTicket ticket, WTodo todo) {
        ConcurrentMap<String, Task> taskMap = wTask.fork();
        if (taskMap.isEmpty()) {
            return Ux.futureL();
        }
        ConcurrentMap<String, JsonObject> assignMap = this.buildAssign(parameters, taskMap, true);
        ArrayList queue = new ArrayList();
        Gain generator = Gain.generator(ticket);
        taskMap.forEach((taskKey, task) -> {
            JsonObject eachData = parameters.copy();
            JsonObject assignData = assignMap.getOrDefault(taskKey, new JsonObject());
            eachData.mergeIn(assignData, true);
            queue.add(generator.buildAsync(eachData, (Task)task, todo));
        });
        return Fn.combineT(queue).compose(generatedQ -> {
            AtomicInteger seed = new AtomicInteger(1);
            generatedQ.forEach(generated -> {
                String serialFork = todo.getSerialFork();
                if (Ut.isNil((String)serialFork)) {
                    generated.setSerialFork(String.valueOf(seed.getAndIncrement()));
                } else {
                    generated.setSerialFork(serialFork);
                }
                this.buildSerial((WTodo)generated, ticket, null);
            });
            return Ux.future((Object)generatedQ);
        });
    }

    private ConcurrentMap<String, JsonObject> buildAssign(JsonObject parameters, ConcurrentMap<String, Task> taskMap, boolean generation) {
        ConcurrentHashMap<String, JsonObject> response = new ConcurrentHashMap<String, JsonObject>();
        taskMap.forEach((taskKey, task) -> {
            String path = this.configuration.getString(taskKey);
            Wf.LOG.Move.info(this.getClass(), "Task key = {0} will parse {1}", new Object[]{taskKey, path});
            JsonObject value = new JsonObject();
            String toUser = (String)Ut.visitTSmart((JsonObject)parameters, (String)path);
            if (generation) {
                value.putNull("toUser");
            } else {
                value.put("toUser", (Object)toUser);
            }
            value.put("acceptedBy", (Object)toUser);
            response.put((String)taskKey, value);
        });
        parameters.remove("toUser");
        parameters.remove("acceptedBy");
        return response;
    }
}

