/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.conformity;

import cn.vertxup.workflow.cv.em.TodoStatus;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.runtime.WTransition;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.Objects;

public final class GVm {
    public static void generate(WTodo generated, WTodo wTask, WTicket ticket) {
        TodoStatus todoStatus = (TodoStatus)Ut.toEnum((String)wTask.getStatus(), TodoStatus.class);
        if (TodoStatus.FINISHED == todoStatus) {
            generated.setStatus(TodoStatus.PENDING.name());
        } else if (TodoStatus.REJECTED == todoStatus) {
            generated.setStatus(TodoStatus.DRAFT.name());
            if (Objects.isNull(generated.getToUser())) {
                generated.setToUser(ticket.getOpenBy());
                generated.setAcceptedBy(ticket.getOpenBy());
                generated.setAcceptedAt(LocalDateTime.now());
            }
        } else if (TodoStatus.REDO == todoStatus) {
            generated.setStatus(TodoStatus.PENDING.name());
            if (Objects.isNull(generated.getToUser())) {
                generated.setToUser(ticket.getOpenBy());
                generated.setAcceptedBy(ticket.getOpenBy());
                generated.setAcceptedAt(LocalDateTime.now());
            }
        }
    }

    public static void finish(JsonObject params, WTransition wTransition) {
        String status = Ut.valueString((JsonObject)params, (String)"status");
        if (Ut.isNil((String)status) || TodoStatus.PENDING.name().equals(status)) {
            params.put("status", (Object)TodoStatus.FINISHED.name());
        }
    }

    public static interface Status {
        public static final JsonArray QUEUE = new JsonArray().add((Object)TodoStatus.PENDING.name()).add((Object)TodoStatus.ACCEPTED.name()).add((Object)TodoStatus.DRAFT.name());
        public static final JsonArray FAILURE = new JsonArray().add((Object)TodoStatus.REJECTED.name()).add((Object)TodoStatus.REDO.name());
    }
}

