/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.conformity;

import cn.vertxup.workflow.cv.em.PassWay;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.runtime.WTask;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.camunda.Io;
import io.vertx.tp.workflow.uca.conformity.Gear;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

public abstract class AbstractGear
implements Gear {
    protected final JsonObject configuration = new JsonObject();
    protected PassWay type;

    protected AbstractGear(PassWay type) {
        this.type = type;
    }

    @Override
    public Gear configuration(JsonObject config) {
        if (Ut.isNotNil((JsonObject)config)) {
            this.configuration.mergeIn(config, true);
        }
        return this;
    }

    @Override
    public Future<WTask> taskAsync(ProcessInstance instance, Task from) {
        Io<Task> io = Io.ioTask();
        return io.children(instance.getId()).compose(taskList -> {
            WTask wTask = new WTask(this.type);
            if (!Objects.isNull(from) && 1 != taskList.size()) {
                Wf.taskNext(from, taskList).forEach(wTask::add);
                return Ux.future((Object)wTask);
            }
            taskList.forEach(wTask::add);
            return Ux.future((Object)wTask);
        });
    }

    protected void buildSerial(WTodo todo, WTicket ticket, Integer sequence) {
        String serialFork = todo.getSerialFork();
        StringBuilder serialBuf = new StringBuilder();
        serialBuf.append(ticket.getSerial()).append("-");
        serialBuf.append(Ut.fromAdjust((Integer)todo.getTraceOrder(), (Integer)2));
        if (Ut.isNil((String)serialFork)) {
            serialBuf.append(0);
            if (Objects.nonNull(sequence)) {
                serialBuf.append("-").append(Ut.fromAdjust((Integer)sequence, (Integer)2));
            }
        } else if (Objects.isNull(sequence)) {
            serialBuf.append(serialFork);
        } else {
            serialBuf.append(serialFork).append("-").append(Ut.fromAdjust((Integer)sequence, (Integer)2));
        }
        todo.setCode(serialBuf.toString());
        todo.setSerial(todo.getCode());
    }
}

