/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.central;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.atom.runtime.WMove;
import io.vertx.tp.workflow.atom.runtime.WRecord;
import io.vertx.tp.workflow.atom.runtime.WRequest;
import io.vertx.tp.workflow.atom.runtime.WTransition;
import io.vertx.tp.workflow.uca.central.Behaviour;
import io.vertx.tp.workflow.uca.toolkit.UTracker;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BehaviourStandard
implements Behaviour {
    protected final transient JsonObject config = new JsonObject();
    private final transient ConcurrentMap<String, WMove> moveMap = new ConcurrentHashMap<String, WMove>();
    private transient UTracker trackerKit;
    private transient MetaInstance metadata;

    @Override
    public Behaviour bind(JsonObject config) {
        JsonObject sure = Ut.valueJObject((JsonObject)config);
        this.config.mergeIn(sure.copy(), true);
        this.config.fieldNames().stream().filter(field -> !"record".equals(field)).filter(field -> !"todo".equals(field)).filter(field -> !"linkage".equals(field)).forEach(field -> {
            JsonObject value = this.config.getJsonObject(field);
            this.moveMap.put((String)field, WMove.create(field, value));
        });
        return this;
    }

    protected MetaInstance metadataIn() {
        return this.metadata;
    }

    @Override
    public Behaviour bind(MetaInstance metadata) {
        Objects.requireNonNull(metadata);
        this.metadata = metadata;
        this.trackerKit = new UTracker(metadata);
        return this;
    }

    protected WTransition createTransition(WRequest request) {
        return WTransition.create(request, this.moveMap);
    }

    protected Future<WRequest> beforeAsync(WRequest request, WTransition wTransition) {
        return wTransition.start().compose(started -> this.trackerKit.beforeAsync(request, (WTransition)started));
    }

    protected Future<WRecord> afterAsync(WRecord record, WTransition wTransition) {
        return wTransition.start().compose(started -> this.trackerKit.afterAsync(record, (WTransition)started));
    }
}

