/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.central;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.atom.runtime.WRecord;
import io.vertx.tp.workflow.atom.runtime.WTransition;
import io.vertx.tp.workflow.uca.central.AbstractTransfer;
import io.vertx.tp.workflow.uca.central.Behaviour;
import io.vertx.tp.workflow.uca.toolkit.ULinkage;
import io.vertx.tp.workflow.uca.toolkit.UTicket;
import java.util.Objects;

public abstract class AbstractMovement
extends AbstractTransfer {
    private transient UTicket todoKit;
    private transient ULinkage linkageKit;

    @Override
    public Behaviour bind(MetaInstance metadata) {
        Objects.requireNonNull(metadata);
        this.todoKit = new UTicket(metadata);
        this.linkageKit = new ULinkage(metadata);
        return super.bind(metadata);
    }

    protected Future<WRecord> insertAsync(JsonObject params, WTransition wTransition) {
        Objects.requireNonNull(this.todoKit);
        Objects.requireNonNull(this.linkageKit);
        return this.todoKit.insertAsync(params, wTransition).compose(record -> this.linkageKit.syncAsync(params, (WRecord)record));
    }

    protected Future<WRecord> updateAsync(JsonObject params, WTransition wTransition) {
        Objects.requireNonNull(this.todoKit);
        Objects.requireNonNull(this.linkageKit);
        return this.todoKit.updateAsync(params, wTransition).compose(record -> this.linkageKit.syncAsync(params, (WRecord)record));
    }

    protected Future<WRecord> saveAsync(JsonObject params, WTransition wTransition) {
        Objects.requireNonNull(this.todoKit);
        Objects.requireNonNull(this.linkageKit);
        return this.todoKit.saveAsync(params, wTransition).compose(record -> this.linkageKit.syncAsync(params, (WRecord)record));
    }
}

