/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.camunda;

import cn.vertxup.workflow.cv.em.TodoStatus;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.runtime.WTransition;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.camunda.Io;
import io.vertx.tp.workflow.uca.camunda.IoTaskKo;
import io.vertx.tp.workflow.uca.camunda.RunOn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;

class RunEngine
implements RunOn {
    RunEngine() {
    }

    @Override
    public Future<ProcessInstance> moveAsync(JsonObject params, WTransition transition) {
        TaskService service = WfPin.camundaTask();
        Task task = transition.from();
        Objects.requireNonNull(task);
        service.complete(task.getId(), Ut.toMap((JsonObject)params));
        ProcessInstance instance = transition.instance();
        Wf.LOG.Move.info(this.getClass(), "[ Move ] Ended = {0}, `instance = {1}` moving with params = {2} !!!", new Object[]{instance.isEnded(), instance.getId(), params.encode()});
        return Ux.future((Object)instance);
    }

    @Override
    public Future<ProcessInstance> startAsync(JsonObject params, WTransition transition) {
        ProcessDefinition definition = transition.definition();
        RuntimeService service = WfPin.camundaRuntime();
        ProcessInstantiationBuilder builder = service.createProcessInstanceByKey(definition.getKey());
        builder.setVariables(Ut.toMap((JsonObject)params));
        ProcessInstance instance = builder.execute();
        Wf.LOG.Move.info(this.getClass(), "[ Start ] `instance = {0}` has been started with params = {1}!!!", new Object[]{instance.getId(), params.encode()});
        return Ux.future((Object)instance);
    }

    @Override
    public Future<Boolean> stopAsync(TodoStatus status, WTransition transition) {
        TaskService service = WfPin.camundaTask();
        return transition.start().compose(started -> {
            Task task = started.from();
            service.setAssignee(task.getId(), IoTaskKo.DELEGATE_DELETE);
            ProcessInstance instance = transition.instance();
            Io<Task> keeps = Io.ioTask(false);
            return keeps.children(instance.getId()).compose(tasks -> {
                if (tasks.isEmpty()) {
                    RuntimeService runtime = WfPin.camundaRuntime();
                    runtime.deleteProcessInstanceIfExists(instance.getId(), status.name(), false, false, false, false);
                }
                return Ux.futureT();
            });
        });
    }
}

