/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.camunda;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.uca.camunda.AbstractIo;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class IoHistory
extends AbstractIo<Set<String>> {
    @Override
    public Future<Set<String>> run(ProcessInstance instance) {
        return Ux.future(this.activities(instance.getId()));
    }

    @Override
    public Future<Set<String>> end(HistoricProcessInstance instance) {
        return Ux.future(this.activities(instance.getId()));
    }

    private Set<String> activities(String instanceId) {
        HistoryService serviceH = WfPin.camundaHistory();
        HistoricActivityInstanceQuery query = serviceH.createHistoricActivityInstanceQuery().processInstanceId(instanceId);
        List activities = query.list();
        HashSet<String> historySet = new HashSet<String>();
        activities.forEach(activity -> historySet.add(activity.getActivityId()));
        return historySet;
    }

    @Override
    public Future<JsonObject> out(JsonObject workflow, Set<String> strings) {
        JsonArray historyA = Ut.toJArray(strings);
        workflow.put("history", (Object)historyA);
        return Ux.future((Object)workflow);
    }
}

