/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.camunda;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.uca.camunda.AbstractIo;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.Task;

class IoForm
extends AbstractIo<JsonObject> {
    IoForm() {
    }

    @Override
    public Future<JsonObject> start(ProcessDefinition definition) {
        Objects.requireNonNull(definition);
        FormService formService = WfPin.camundaForm();
        StartFormData startForm = formService.getStartFormData(definition.getId());
        Objects.requireNonNull(startForm);
        String formKey = startForm.getFormKey();
        Objects.requireNonNull(formKey);
        String code = formKey.substring(formKey.lastIndexOf(":") + 1);
        return Ux.future((Object)this.formInput(code, definition));
    }

    @Override
    public Future<JsonObject> run(Task task) {
        ProcessDefinition definition = this.inProcess(task.getProcessDefinitionId());
        Objects.requireNonNull(definition);
        String formKey = task.getFormKey();
        Objects.requireNonNull(formKey);
        String code = formKey.substring(formKey.lastIndexOf(":") + 1);
        return Ux.future((Object)this.formInput(code, definition));
    }

    @Override
    public Future<JsonObject> end(HistoricProcessInstance instance) {
        ProcessDefinition definition = this.inProcess(instance.getProcessDefinitionId());
        return Ux.future((Object)this.formInput("workflow.history", definition));
    }

    @Override
    public Future<JsonObject> out(JsonObject workflow, JsonObject formData) {
        if (Ut.isNotNil((JsonObject)formData)) {
            workflow.put("form", (Object)formData);
        }
        return Ux.future((Object)workflow);
    }

    private JsonObject formInput(String code, ProcessDefinition definition) {
        String definitionKey = definition.getKey();
        String configFile = "workflow/" + definitionKey + "/" + code + ".json";
        JsonObject formParameters = new JsonObject();
        if (Ut.ioExist((String)configFile)) {
            formParameters.put("dynamic", (Object)Boolean.FALSE);
            formParameters.put("code", (Object)configFile);
        } else {
            formParameters.put("dynamic", (Object)Boolean.TRUE);
            formParameters.put("code", (Object)code);
        }
        return formParameters;
    }
}

