/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.camunda;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.camunda.AbstractIo;
import io.vertx.tp.workflow.uca.camunda.Io;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

public class IoFlow
extends AbstractIo<JsonObject> {
    @Override
    public Future<JsonObject> start(ProcessDefinition definition) {
        JsonObject workflow = Wf.outBpmn(definition);
        Io<StartEvent> ioStart = Io.ioEventStart();
        return Ux.future((Object)definition.getId()).compose(ioStart::child).compose(starts -> ioStart.out(workflow, (StartEvent)starts));
    }

    @Override
    public Future<JsonObject> end(HistoricProcessInstance instance) {
        ProcessDefinition definition = this.inProcess(instance.getProcessDefinitionId());
        JsonObject workflow = Wf.outBpmn(definition);
        Io<EndEvent> ioEnd = Io.ioEventEnd();
        Io<Set<String>> ioHistory = Io.ioHistory();
        return Ux.future((Object)definition.getId()).compose(ioEnd::children).compose(ends -> ioEnd.out(workflow, (List<EndEvent>)ends)).compose(nil -> ioHistory.end(instance)).compose(historySet -> ioHistory.out(workflow, (Set<String>)historySet));
    }

    @Override
    public Future<JsonObject> run(Task task) {
        ProcessDefinition definition = this.inProcess(task.getProcessDefinitionId());
        JsonObject workflow = Wf.outBpmn(definition);
        ProcessInstance instance = this.inInstance(task.getProcessInstanceId());
        Io<Set<String>> ioHistory = Io.ioHistory();
        Io<Task> ioTask = Io.ioTask();
        return ioTask.out(workflow, task).compose(nil -> ioHistory.run(instance)).compose(historySet -> {
            historySet.remove(task.getTaskDefinitionKey());
            return ioHistory.out(workflow, (Set<String>)historySet);
        });
    }

    @Override
    public Future<JsonObject> out(JsonObject response, JsonObject workflow) {
        if (Ut.isNotNil((JsonObject)workflow)) {
            response.put("workflow", (Object)workflow);
        }
        return Ux.future((Object)response);
    }
}

