/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.camunda;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._409EventStartUniqueException;
import io.vertx.tp.error._501EventStartMissingException;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.uca.camunda.AbstractIo;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

class IoEventStart
extends AbstractIo<StartEvent> {
    IoEventStart() {
    }

    @Override
    public Future<List<StartEvent>> children(String definitionId) {
        if (Ut.isNil((String)definitionId)) {
            return Ux.futureL();
        }
        RepositoryService service = WfPin.camundaRepository();
        BpmnModelInstance instance = service.getBpmnModelInstance(definitionId);
        Collection starts = instance.getModelElementsByType(StartEvent.class);
        if (starts.isEmpty()) {
            return Fn.outWeb(_501EventStartMissingException.class, (Object[])new Object[]{this.getClass(), definitionId});
        }
        return Ux.future(new ArrayList(starts));
    }

    @Override
    public Future<StartEvent> child(String definitionId) {
        return this.children(definitionId).compose(list -> {
            int size = list.size();
            if (1 == size) {
                return Ux.future((Object)((StartEvent)list.get(0)));
            }
            return Fn.outWeb(_409EventStartUniqueException.class, (Object[])new Object[]{this.getClass(), size, definitionId});
        });
    }

    @Override
    public Future<JsonObject> out(JsonObject workflow, List<StartEvent> starts) {
        if (1 == starts.size()) {
            StartEvent event = starts.get(0);
            workflow.put("task", (Object)event.getId());
            workflow.put("taskName", (Object)event.getName());
        } else {
            JsonObject taskMap = new JsonObject();
            starts.forEach(start -> taskMap.put(start.getId(), (Object)start.getName()));
            workflow.put("task", (Object)taskMap);
        }
        return Ux.future((Object)workflow);
    }
}

