/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.uca.camunda;

import cn.vertxup.workflow.cv.WfPool;
import io.vertx.tp.error._404ProcessMissingException;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.uca.camunda.Io;
import java.util.Objects;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public abstract class AbstractIo<I>
implements Io<I> {
    @Override
    public ProcessDefinition inProcess(String idOrKey) {
        Objects.requireNonNull(idOrKey);
        ProcessDefinition result = (ProcessDefinition)WfPool.CC_DEFINITION.pick(() -> {
            RepositoryService service = WfPin.camundaRepository();
            ProcessDefinitionQuery query = service.createProcessDefinitionQuery().processDefinitionId(idOrKey);
            ProcessDefinition definition = (ProcessDefinition)query.singleResult();
            if (Objects.nonNull(definition)) {
                return definition;
            }
            return (ProcessDefinition)service.createProcessDefinitionQuery().latestVersion().processDefinitionKey(idOrKey).singleResult();
        }, (Object)idOrKey);
        if (Objects.isNull(result)) {
            throw new _404ProcessMissingException(this.getClass(), idOrKey);
        }
        return result;
    }

    @Override
    public ProcessInstance inInstance(String instanceId) {
        RuntimeService service = WfPin.camundaRuntime();
        return (ProcessInstance)service.createProcessInstanceQuery().processInstanceId(instanceId).singleResult();
    }

    @Override
    public HistoricProcessInstance inHistoric(String instanceId) {
        HistoryService service = WfPin.camundaHistory();
        return (HistoricProcessInstance)service.createHistoricProcessInstanceQuery().processInstanceId(instanceId).singleResult();
    }
}

