/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.refine;

import cn.vertxup.workflow.cv.em.PassWay;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.impl.instance.Outgoing;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

class WfFlow {
    WfFlow() {
    }

    static JsonObject outBpmn(ProcessDefinition definition) {
        RepositoryService service = WfPin.camundaRepository();
        BpmnModelInstance instance = service.getBpmnModelInstance(definition.getId());
        Objects.requireNonNull(instance);
        String xml = Bpmn.convertToString((BpmnModelInstance)instance);
        JsonObject workflow = new JsonObject();
        workflow.put("definitionId", (Object)definition.getId());
        workflow.put("definitionKey", (Object)definition.getKey());
        workflow.put("bpmn", (Object)xml);
        workflow.put("name", (Object)definition.getName());
        return workflow;
    }

    static JsonObject outLinkage(JsonObject linkageJ) {
        JsonObject parsed = new JsonObject();
        linkageJ.fieldNames().forEach(field -> {
            Object value = linkageJ.getValue(field);
            JsonObject json = null;
            if (value instanceof String) {
                json = Ut.ioJObject((String)value.toString());
            } else if (value instanceof JsonObject) {
                json = (JsonObject)value;
            }
            if (Ut.isNotNil((JsonObject)json)) {
                assert (json != null);
                parsed.put(field, (Object)json.copy());
            }
        });
        return parsed;
    }

    static PassWay inGateway(JsonObject requestJ) {
        JsonObject requestData = Ut.valueJObject((JsonObject)requestJ);
        Object toUser = requestData.getValue("toUser");
        if (toUser instanceof String) {
            return PassWay.Standard;
        }
        if (toUser instanceof JsonArray) {
            return PassWay.Multi;
        }
        if (toUser instanceof JsonObject) {
            JsonObject toUserJ = (JsonObject)toUser;
            Set typeSet = toUserJ.fieldNames();
            long strCount = typeSet.stream().filter(field -> toUserJ.getValue(field) instanceof String).count();
            if ((long)typeSet.size() == strCount) {
                return PassWay.Fork;
            }
            return PassWay.Grid;
        }
        return null;
    }

    static String nameEvent(Task task) {
        if (Objects.isNull(task)) {
            return null;
        }
        RepositoryService service = WfPin.camundaRepository();
        BpmnModelInstance instance = service.getBpmnModelInstance(task.getProcessDefinitionId());
        ModelElementInstance node = instance.getModelElementById(task.getTaskDefinitionKey());
        return node.getElementType().getTypeName();
    }

    static List<Task> taskNext(Task task, List<Task> source) {
        Objects.requireNonNull(task);
        RepositoryService service = WfPin.camundaRepository();
        BpmnModelInstance instance = service.getBpmnModelInstance(task.getProcessDefinitionId());
        ModelElementInstance node = instance.getModelElementById(task.getTaskDefinitionKey());
        Set<String> nextKeys = WfFlow.taskSearch(node, instance);
        Wf.LOG.Move.info(WfFlow.class, "[Outgoing] Keys = {0}", new Object[]{Ut.fromJoin(nextKeys)});
        return source.stream().filter(taskNext -> nextKeys.contains(taskNext.getTaskDefinitionKey())).collect(Collectors.toList());
    }

    private static Set<String> taskSearch(ModelElementInstance nodeTask, BpmnModelInstance instance) {
        Collection outgoing = nodeTask.getChildElementsByType(Outgoing.class);
        HashSet<String> keys = new HashSet<String>();
        outgoing.forEach(child -> {
            ModelElementInstance sequence = instance.getModelElementById(child.getTextContent());
            if (sequence instanceof SequenceFlow) {
                FlowNode target = ((SequenceFlow)sequence).getTarget();
                ModelElementInstance found = instance.getModelElementById(target.getId());
                if (found instanceof UserTask) {
                    keys.add(target.getId());
                } else {
                    Set<String> continueSearch = WfFlow.taskSearch(found, instance);
                    keys.addAll(continueSearch);
                }
            }
        });
        return keys;
    }
}

