/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.plugin.activity;

import io.horizon.eon.em.typed.ChangeFlag;
import io.horizon.spi.feature.Valve;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.uca.camunda.Io;
import io.vertx.up.eon.KName;
import io.vertx.up.uca.sectio.After;
import io.vertx.up.uca.sectio.Around;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Set;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ActivityTabb
implements After {
    public Set<ChangeFlag> types() {
        return Around.TYPE_ALL;
    }

    public Future<JsonObject> afterAsync(JsonObject data, JsonObject config) {
        JsonObject normalized = data.copy();
        return this.dataCond(normalized).compose(criteria -> {
            normalized.put("criteria", criteria);
            return Ux.future((Object)normalized);
        }).compose(this::dataFlow).compose(workflow -> {
            normalized.put("workflow", workflow);
            return Ux.future((Object)normalized);
        }).compose(processed -> this.dataDelay((JsonObject)processed, config)).compose(processed -> Ux.channel(Valve.class, () -> data, valve -> valve.execAsync(processed, config))).compose(nil -> Ux.future((Object)data));
    }

    private Future<JsonObject> dataDelay(JsonObject normalized, JsonObject config) {
        JsonObject user = new JsonObject();
        JsonArray auditorJ = Ut.valueJArray((JsonObject)config, (String)"auditor");
        auditorJ.addAll(Ut.toJArray((Set)KName.Auditor.USER_FIELDS));
        user.put("user", (Object)auditorJ);
        user.put("role", (Object)new JsonArray().add((Object)"toRole"));
        user.put("group", (Object)new JsonArray().add((Object)"toGroup"));
        user.put("dept", (Object)new JsonArray().add((Object)"toDept"));
        user.put("team", (Object)new JsonArray().add((Object)"toTeam"));
        normalized.put("__user", (Object)user);
        return Ux.future((Object)normalized);
    }

    private Future<JsonObject> dataCond(JsonObject data) {
        JsonObject criteria = Ux.whereAnd();
        criteria.put("definitionKey", data.getValue("flowDefinitionKey"));
        criteria.put("taskKey", data.getValue("taskKey"));
        return Ux.future((Object)criteria);
    }

    private Future<JsonObject> dataFlow(JsonObject data) {
        JsonObject workflow = new JsonObject();
        Ut.valueCopy((JsonObject)workflow, (JsonObject)data, (String[])new String[]{"flowDefinitionKey", "flowDefinitionId", "flowInstanceId", "taskId", "taskName", "taskSerial", "taskKey", "taskCode"});
        workflow.put("instanceId", data.getValue("flowInstanceId"));
        workflow.put("definitionKey", data.getValue("flowDefinitionKey"));
        workflow.put("definitionId", data.getValue("flowDefinitionId"));
        String definitionKey = workflow.getString("definitionKey");
        Io<Void> io = Io.io();
        ProcessDefinition definition = io.inProcess(definitionKey);
        workflow.put("name", (Object)definition.getName());
        return Ux.future((Object)workflow);
    }
}

