/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.init;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class WfTodo {
    private static final ConcurrentMap<String, JsonObject> TODO_DEF = new ConcurrentHashMap<String, JsonObject>();

    private WfTodo() {
    }

    static void init() {
        if (TODO_DEF.isEmpty()) {
            List files = Ut.ioFiles((String)"plugin/wf/todo/", (String)"json");
            Wf.LOG.Init.info(WfTodo.class, "At Todo Files: {0}", new Object[]{files.size()});
            files.forEach(file -> {
                String path = "plugin/wf/todo/" + file;
                JsonObject todoDef = Ut.ioJObject((String)path);
                String key = file.replace(".json", "");
                TODO_DEF.put(key, todoDef);
            });
        }
    }

    static JsonObject getTodo(String type) {
        JsonObject todoDef = (JsonObject)TODO_DEF.get(type);
        return Objects.isNull(todoDef) ? new JsonObject() : todoDef.copy();
    }
}

