/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom.runtime;

import io.aeon.experiment.specification.KFlow;
import io.vertx.tp.workflow.atom.runtime.WMove;
import io.vertx.tp.workflow.uca.camunda.Io;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.camunda.bpm.engine.repository.ProcessDefinition;

class WTransitionDefine {
    private final ProcessDefinition definition;
    private final KFlow workflow;
    private final ConcurrentMap<String, WMove> move = new ConcurrentHashMap<String, WMove>();

    WTransitionDefine(KFlow workflow, ConcurrentMap<String, WMove> move) {
        this.workflow = workflow;
        Io<Void> io = Io.io();
        this.definition = io.inProcess(workflow.definitionId());
        if (Objects.nonNull(move)) {
            this.move.clear();
            this.move.putAll(move);
        }
    }

    ProcessDefinition definition() {
        return this.definition;
    }

    KFlow workflow() {
        return this.workflow;
    }

    WMove rule(String node) {
        return this.move.getOrDefault(node, WMove.empty());
    }
}

