/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom.runtime;

import cn.vertxup.workflow.cv.em.PassWay;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import io.aeon.experiment.specification.KFlow;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._409InValidInstanceException;
import io.vertx.tp.workflow.atom.runtime.WMove;
import io.vertx.tp.workflow.atom.runtime.WRequest;
import io.vertx.tp.workflow.atom.runtime.WRule;
import io.vertx.tp.workflow.atom.runtime.WTask;
import io.vertx.tp.workflow.atom.runtime.WTransitionDefine;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.camunda.Io;
import io.vertx.tp.workflow.uca.conformity.Gear;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.sectio.AspectConfig;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

public class WTransition {
    private final WTransitionDefine define;
    private ProcessInstance instance;
    private Task from;
    private WRule rule = WMove.RULE_EMPTY;
    private WTask to;
    private WMove move;
    private PassWay way;

    private WTransition(KFlow workflow, ConcurrentMap<String, WMove> move) {
        this.define = new WTransitionDefine(workflow, move);
        Io<Void> io = Io.io();
        if (Ut.isNotNil((String)workflow.instanceId())) {
            this.instance = io.inInstance(workflow.instanceId());
        }
    }

    public static WTransition create(WRequest request, ConcurrentMap<String, WMove> move) {
        KFlow workflow = request.workflow();
        WTransition transition = new WTransition(workflow, move);
        transition.way = Wf.inGateway(request.request());
        return transition;
    }

    public Task from() {
        return this.from;
    }

    public WTask to() {
        return this.to;
    }

    public ProcessInstance instance() {
        return this.instance;
    }

    public ProcessDefinition definition() {
        return this.define.definition();
    }

    public AspectConfig aspect() {
        return Objects.isNull(this.move) ? AspectConfig.create() : this.move.configAop();
    }

    public PassWay vague() {
        return Objects.isNull(this.to) ? null : this.to.vague();
    }

    public JsonObject moveParameter(WRequest request) {
        JsonObject requestJ = request.request();
        if (Objects.isNull(this.move)) {
            return new JsonObject();
        }
        JsonObject moveData = this.move.inputMovement(requestJ);
        this.rule = this.move.inputTransfer(moveData);
        return moveData;
    }

    public JsonObject moveTicket(JsonObject requestJ) {
        JsonObject todoJ = Ut.fromExpression((JsonObject)this.rule.getTodo(), (JsonObject)requestJ);
        requestJ.mergeIn(todoJ, true);
        requestJ.mergeIn(Ut.fromExpression((JsonObject)this.rule.getTicket(), (JsonObject)requestJ), true);
        requestJ.mergeIn(Ut.fromExpression((JsonObject)this.rule.getExtension(), (JsonObject)requestJ), true);
        return this.moveRecord(requestJ);
    }

    public JsonObject moveRecord(JsonObject requestJ) {
        Object recordRef = requestJ.getValue("record");
        if (Objects.isNull(recordRef)) {
            return requestJ;
        }
        JsonObject recordData = Ut.fromExpression((JsonObject)this.rule.getRecord(), (JsonObject)requestJ);
        if (recordRef instanceof JsonObject) {
            JsonObject recordJ2 = (JsonObject)recordRef;
            recordJ2.mergeIn(recordData, true);
            requestJ.put("record", (Object)recordJ2);
        } else if (recordRef instanceof JsonArray) {
            JsonArray recordA = (JsonArray)recordRef;
            Ut.itJArray((JsonArray)recordA).forEach(recordJ -> recordJ.mergeIn(recordData, true));
            requestJ.put("record", (Object)recordA);
        }
        return requestJ;
    }

    public Future<WTransition> end(ProcessInstance instance) {
        Objects.requireNonNull(this.move);
        this.instance = instance;
        Gear gear = Gear.instance(this.way);
        gear.configuration(this.move.configWay());
        return gear.taskAsync(instance, this.from).compose(wTask -> {
            this.to = wTask;
            return Ux.future((Object)this);
        });
    }

    public Future<List<WTodo>> end(JsonObject parameters, WTicket ticket) {
        Objects.requireNonNull(this.move);
        Gear gear = Gear.instance(this.vague());
        gear.configuration(this.move.configWay());
        return gear.todoAsync(parameters, this.to, ticket);
    }

    public Future<List<WTodo>> end(JsonObject parameters, WTicket ticket, WTodo todo) {
        Objects.requireNonNull(this.move);
        Gear gear = Gear.instance(this.vague());
        gear.configuration(this.move.configWay());
        return gear.todoAsync(parameters, this.to, ticket, todo);
    }

    public Future<WTransition> start() {
        if (Objects.nonNull(this.move)) {
            return Ux.future((Object)this);
        }
        KFlow flow = this.define.workflow();
        String taskId = flow.taskId();
        if (Ut.isNil((String)taskId)) {
            ProcessDefinition definition = this.definition();
            Wf.LOG.Move.info(this.getClass(), "Flow Not Started, rule fetched by definition = {0}", new Object[]{definition.getId()});
            Io<StartEvent> io = Io.ioEventStart();
            return io.child(definition.getId()).compose(event -> {
                this.move = this.define.rule(event.getId());
                Objects.requireNonNull(this.move);
                return Ux.future((Object)this);
            });
        }
        Objects.requireNonNull(this.instance);
        Io<Task> ioTask = Io.ioTask();
        return ioTask.run(flow.taskId()).compose(task -> {
            if (Objects.isNull(task)) {
                return Fn.outWeb(_409InValidInstanceException.class, (Object[])new Object[]{this.getClass(), this.instance.getId()});
            }
            this.from = task;
            this.move = this.define.rule(task.getTaskDefinitionKey());
            Objects.requireNonNull(this.move);
            return Ux.future((Object)this);
        });
    }

    public boolean isStarted() {
        return Objects.nonNull(this.instance);
    }

    public boolean isEnded() {
        if (Objects.isNull(this.instance)) {
            return true;
        }
        Io<Void> io = Io.io();
        ProcessInstance instance = io.inInstance(this.instance.getId());
        return Objects.isNull(instance);
    }

    public boolean isRunning() {
        boolean isEnd = this.isEnded();
        if (isEnd) {
            return Boolean.FALSE;
        }
        if (Objects.isNull(this.to)) {
            return Boolean.FALSE;
        }
        if (this.to.isEmpty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

