/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom.runtime;

import cn.vertxup.workflow.cv.em.PassWay;
import io.vertx.tp.error._409InValidTaskApiException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.camunda.bpm.engine.task.Task;

public class WTask {
    private final ConcurrentMap<String, ConcurrentMap<String, Task>> tasks = new ConcurrentHashMap<String, ConcurrentMap<String, Task>>();
    private final PassWay type;

    public WTask(PassWay type) {
        Objects.requireNonNull(type);
        this.type = type;
    }

    public WTask add(Task task) {
        if (Objects.nonNull(task)) {
            ConcurrentMap<String, Task> taskRef;
            String taskKey = task.getTaskDefinitionKey();
            if (this.tasks.containsKey(taskKey)) {
                taskRef = (ConcurrentMap)this.tasks.get(taskKey);
            } else {
                taskRef = new ConcurrentHashMap();
                this.tasks.put(taskKey, taskRef);
            }
            taskRef.put(task.getId(), task);
        }
        return this;
    }

    public Task standard() {
        this.ensure(PassWay.Standard);
        if (this.tasks.isEmpty()) {
            return null;
        }
        ConcurrentMap item = (ConcurrentMap)this.tasks.values().iterator().next();
        if (Objects.isNull(item) || item.isEmpty()) {
            return null;
        }
        return (Task)item.values().iterator().next();
    }

    public List<Task> multi() {
        this.ensure(PassWay.Multi);
        if (this.tasks.isEmpty()) {
            return new ArrayList<Task>();
        }
        ConcurrentMap item = (ConcurrentMap)this.tasks.values().iterator().next();
        if (Objects.isNull(item) || item.isEmpty()) {
            return new ArrayList<Task>();
        }
        return new ArrayList<Task>(item.values());
    }

    public ConcurrentMap<String, Task> fork() {
        this.ensure(PassWay.Fork);
        if (this.tasks.isEmpty()) {
            return new ConcurrentHashMap<String, Task>();
        }
        ConcurrentHashMap<String, Task> taskMap = new ConcurrentHashMap<String, Task>();
        this.tasks.forEach((taskKey, valueMap) -> {
            Task task = (Task)valueMap.values().iterator().next();
            taskMap.put((String)taskKey, task);
        });
        return taskMap;
    }

    public ConcurrentMap<String, List<Task>> grid() {
        this.ensure(PassWay.Grid);
        if (this.tasks.isEmpty()) {
            return new ConcurrentHashMap<String, List<Task>>();
        }
        ConcurrentHashMap<String, List<Task>> taskMap = new ConcurrentHashMap<String, List<Task>>();
        this.tasks.forEach((taskKey, valueMap) -> {
            ArrayList valueList = new ArrayList(valueMap.values());
            if (!valueList.isEmpty()) {
                taskMap.put((String)taskKey, valueList);
            }
        });
        return taskMap;
    }

    private void ensure(PassWay expected) {
        if (expected != this.type) {
            throw new _409InValidTaskApiException(this.getClass(), this.type, expected);
        }
    }

    public PassWay vague() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }
}

