/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom.runtime;

import cn.vertxup.workflow.cv.em.PassWay;
import cn.vertxup.workflow.cv.em.TodoStatus;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import io.horizon.eon.em.typed.ChangeFlag;
import io.horizon.spi.business.ExActivity;
import io.horizon.spi.component.Dictionary;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.EngineOn;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.uca.camunda.Io;
import io.vertx.tp.workflow.uca.modeling.ActionOn;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.task.Task;

public class WRecord
implements Serializable {
    private final transient ConcurrentMap<String, JsonArray> linkage = new ConcurrentHashMap<String, JsonArray>();
    private final transient JsonObject child = new JsonObject();
    private final transient JsonObject dataAfter = new JsonObject();
    private final transient ChangeFlag tabb;
    private transient PassWay type;
    private WRecord prev;
    private WTicket ticket;
    private List<WTodo> todo = new ArrayList<WTodo>();

    private WRecord(ChangeFlag tabb) {
        this.tabb = tabb;
    }

    private WRecord() {
        this(null);
    }

    public static WRecord create() {
        return WRecord.create(false, null);
    }

    public static WRecord create(boolean write, ChangeFlag flag) {
        if (write) {
            Objects.requireNonNull(flag);
            return new WRecord(flag).prev(new WRecord());
        }
        return new WRecord();
    }

    public WRecord prev() {
        return this.prev;
    }

    public WRecord prev(WRecord prev) {
        this.prev = prev;
        return this;
    }

    public WRecord bind() {
        this.todo = new ArrayList<WTodo>();
        this.ticket = null;
        return this;
    }

    public WRecord bind(PassWay type) {
        this.type = type;
        return this;
    }

    public WRecord ticket(WTicket ticket) {
        this.ticket = (WTicket)Ux.cloneT((Object)ticket);
        return this;
    }

    public WRecord task(WTodo todo) {
        this.todo.clear();
        this.todo.add((WTodo)Ux.cloneT((Object)todo));
        return this;
    }

    public WRecord task(List<WTodo> todoList) {
        if (Objects.nonNull(todoList)) {
            this.todo.clear();
            this.todo.addAll(todoList);
        }
        return this;
    }

    public WRecord ticket(JsonObject child) {
        if (Ut.isNotNil((JsonObject)child)) {
            this.child.mergeIn(child.copy());
        }
        return this;
    }

    public WRecord linkage(String field, JsonArray linkage) {
        JsonArray data = Ut.valueJArray((JsonArray)linkage);
        this.linkage.put(field, data);
        return this;
    }

    public WTodo task() {
        if (this.todo.isEmpty() || 1 < this.todo.size()) {
            return null;
        }
        return this.todo.get(0);
    }

    public PassWay way() {
        return this.type;
    }

    public WTicket ticket() {
        return this.ticket;
    }

    public JsonObject child() {
        return this.child;
    }

    public String identifier() {
        return this.ticket.getModelId();
    }

    public String key() {
        return this.ticket.getModelKey();
    }

    public TodoStatus status() {
        if (Objects.isNull(this.prev) || Objects.isNull(this.prev.todo)) {
            return null;
        }
        WTodo todo = this.prev.task();
        return (TodoStatus)Ut.toEnum(todo::getStatus, TodoStatus.class, null);
    }

    public Future<JsonObject> futureJ() {
        return Ux.future((Object)this.data());
    }

    public Future<JsonObject> futureJ(boolean history) {
        JsonObject response = this.data();
        return this.dataProcess(history).compose(workflow -> this.dataTicket(response, (JsonObject)workflow)).compose(this::dataHistory).compose(Fn.ofJObject((String)"history", (JsonObject)response));
    }

    public Future<WRecord> futureAfter(JsonObject dataAfter) {
        if (Ut.isNotNil((JsonObject)dataAfter)) {
            this.dataAfter.clear();
            this.dataAfter.mergeIn(dataAfter, true);
        }
        return Ux.future((Object)this);
    }

    private Future<JsonObject> dataTicket(JsonObject response, JsonObject workflow) {
        EngineOn engine = EngineOn.connect(workflow.getString("definitionKey"));
        MetaInstance metadataInput = engine.metadata();
        ActionOn action = ActionOn.action(metadataInput.recordMode());
        MetaInstance metadataOutput = MetaInstance.output(this, metadataInput);
        if (metadataOutput.recordSkip().booleanValue()) {
            return Ux.future((Object)response);
        }
        String modelKey = this.ticket.getModelKey();
        if (Objects.isNull(modelKey)) {
            Set keys = Ut.toSet((JsonArray)Ut.toJArray((String)this.ticket.getModelChild()));
            return action.fetchAsync(keys, this.ticket.getModelId(), metadataOutput).compose(array -> {
                response.put("record", array);
                return Ux.future((Object)response);
            });
        }
        return action.fetchAsync(this.ticket.getModelKey(), this.ticket.getModelId(), metadataOutput).compose(json -> {
            response.put("record", json);
            return Ux.future((Object)response);
        });
    }

    private Future<JsonObject> dataProcess(boolean history) {
        Io<JsonObject> ioFlow = Io.ioFlow();
        if (!history) {
            WTodo todo = this.task();
            Objects.requireNonNull(todo);
            Io<Task> ioTask = Io.ioTask();
            String taskId = todo.getTaskId();
            return ioTask.run(taskId).compose(x$0 -> ioFlow.run((Task)x$0));
        }
        Objects.requireNonNull(this.ticket);
        String instanceId = this.ticket.getFlowInstanceId();
        HistoricProcessInstance instance = ioFlow.inHistoric(instanceId);
        return ioFlow.end(instance);
    }

    private Future<JsonArray> dataHistory(JsonObject processed) {
        return Ux.channel(Dictionary.class, JsonArray::new, dict -> dict.fetchTree(this.ticket.getSigma(), "zero.service.catalog")).compose(dict -> {
            ConcurrentHashMap mapId = new ConcurrentHashMap();
            Ut.itJArray((JsonArray)dict).forEach(record -> {
                String code = record.getString("code");
                String identifier = record.getString("identifier");
                if (Objects.nonNull(code) && Objects.nonNull(identifier)) {
                    mapId.put(code, identifier);
                }
            });
            return Ux.future(mapId);
        }).compose(map -> Ux.channel(ExActivity.class, JsonArray::new, activity -> {
            if (Objects.isNull(this.ticket.getCatalog())) {
                return Ux.futureA();
            }
            String modelId = map.getOrDefault(this.ticket.getCatalog(), null);
            if (Objects.isNull(modelId)) {
                return Ux.futureA();
            }
            return activity.activities(modelId, this.ticket.getKey());
        }));
    }

    public JsonObject data() {
        JsonObject response = new JsonObject();
        if (Objects.nonNull(this.ticket)) {
            this.onTicket(response);
            this.onChild(response);
            WTodo todo = this.task();
            if (Objects.nonNull(todo)) {
                this.onTodo(response, todo);
            }
            this.onCompare(response);
        }
        return response;
    }

    public JsonArray dataAop() {
        JsonArray response = new JsonArray();
        if (Objects.nonNull(this.ticket)) {
            JsonObject ticketJ = new JsonObject();
            this.onTicket(ticketJ);
            this.onChild(ticketJ);
            this.todo.forEach(todoItem -> {
                JsonObject ticketData = ticketJ.copy();
                this.onTodo(ticketData, (WTodo)todoItem);
                this.onCompare(ticketData);
                response.add((Object)ticketData);
            });
        }
        return response;
    }

    private void onCompare(JsonObject response) {
        JsonObject dataPrev;
        if (Objects.nonNull(this.prev) && Ut.isNotNil((JsonObject)(dataPrev = this.prev.data()))) {
            response.put("__data", (Object)dataPrev);
        }
        if (Objects.nonNull(this.tabb)) {
            response.put("__flag", (Object)this.tabb);
        }
        JsonObject dataAfter = this.dataAfter.copy();
        dataAfter.remove("key");
        dataAfter.remove("code");
        dataAfter.remove("serial");
        response.mergeIn(dataAfter, true);
    }

    private void onTicket(JsonObject response) {
        JsonObject ticketJ = Ux.toJson((Object)this.ticket);
        Ut.valueToJObject((JsonObject)ticketJ, (String[])new String[]{"modelChild"});
        ticketJ.put("traceKey", (Object)this.ticket.getKey());
        response.mergeIn(ticketJ, true);
    }

    private void onTodo(JsonObject response, WTodo todo) {
        JsonObject todoJson = Ux.toJson((Object)todo);
        todoJson.remove("serial");
        todoJson.remove("code");
        response.mergeIn(todoJson, true);
        response.put("taskCode", (Object)todo.getCode());
        response.put("taskSerial", (Object)todo.getSerial());
    }

    private void onChild(JsonObject result) {
        this.linkage.forEach((arg_0, arg_1) -> ((JsonObject)result).put(arg_0, arg_1));
        if (Ut.isNotNil((JsonObject)this.child)) {
            JsonObject childJ = this.child.copy();
            if (!result.containsKey("traceKey")) {
                result.put("traceKey", childJ.getValue("key"));
            }
            childJ.remove("key");
            result.mergeIn(childJ);
        }
    }
}

