/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom.runtime;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.runtime.WRule;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.up.uca.sectio.AspectConfig;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WMove
implements Serializable {
    static final WRule RULE_EMPTY = new WRule();
    private final ConcurrentMap<String, WRule> rules = new ConcurrentHashMap<String, WRule>();
    private final String node;
    private final JsonObject data = new JsonObject();
    private final Set<String> required = new HashSet<String>();
    private final AspectConfig aspect;
    private final JsonObject gateway = new JsonObject();

    private WMove(String node, JsonObject config) {
        this.node = node;
        JsonObject expression = new JsonObject();
        JsonObject original = Ut.valueJObject((JsonObject)config.getJsonObject("data"));
        Ut.itJObject((JsonObject)original, (to, from) -> {
            this.required.add((String)to);
            String valueExpr = "`${" + to + "}`";
            expression.put(from, (Object)valueExpr);
        });
        this.data.mergeIn(expression, true);
        JsonArray rules = Ut.valueJArray((JsonArray)config.getJsonArray("rule"));
        Ut.itJArray((JsonArray)rules).forEach(json -> {
            WRule rule = (WRule)Ux.fromJson((JsonObject)json, WRule.class);
            if (rule.valid()) {
                this.rules.put(rule.key(), rule);
            } else {
                Wf.LOG.Move.warn(this.getClass(), "Rule invalid: {0}", new Object[]{rule.toString()});
            }
        });
        this.aspect = AspectConfig.create((JsonObject)Ut.valueJObject((JsonObject)config, (String)"aspect"));
        this.gateway.mergeIn(Ut.valueJObject((JsonObject)config, (String)"gateway"));
    }

    public static WMove create(String node, JsonObject config) {
        return new WMove(node, config);
    }

    public static WMove empty() {
        return new WMove(null, new JsonObject());
    }

    AspectConfig configAop() {
        return this.aspect;
    }

    JsonObject configWay() {
        return this.gateway.copy();
    }

    JsonObject inputMovement(JsonObject requestJ) {
        this.required.forEach(fieldExpr -> {
            if (!requestJ.containsKey(fieldExpr)) {
                requestJ.putNull(fieldExpr);
            }
        });
        return Ut.fromExpression((JsonObject)this.data, (JsonObject)requestJ);
    }

    WRule inputTransfer(JsonObject params) {
        TreeSet keys = new TreeSet();
        params.fieldNames().forEach(field -> {
            Object value = params.getValue(field);
            if (Objects.nonNull(value)) {
                String key = field + "=" + value;
                keys.add(key);
            }
        });
        String key = Ut.fromJoin(keys);
        WRule rule = this.rules.getOrDefault(key, RULE_EMPTY);
        Wf.LOG.Move.info(this.getClass(), "[ Rule ] The node `{0}` rule processed: {1}", new Object[]{this.node, rule});
        return rule;
    }
}

