/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom.configuration;

import io.horizon.uca.cache.Cc;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.modeling.Respect;
import io.vertx.tp.workflow.uca.modeling.RespectLink;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class ConfigLinkage
implements Serializable {
    private static final Cc<String, Respect> CC_RESPECT = Cc.open();
    private final transient ConcurrentMap<String, Class<?>> respectMap = new ConcurrentHashMap();
    private final transient ConcurrentMap<String, JsonObject> queryMap = new ConcurrentHashMap<String, JsonObject>();

    ConfigLinkage(JsonObject linkageJ) {
        JsonObject parsedJ = Wf.outLinkage(linkageJ);
        Ut.itJObject((JsonObject)parsedJ, (json, field) -> {
            JsonObject config = Ut.valueJObject((JsonObject)json, (String)"config");
            if (Ut.isNotNil((JsonObject)config)) {
                Class clazz = Ut.clazz((String)config.getString("respect"), null);
                if (Objects.isNull(clazz)) {
                    this.respectMap.put((String)field, RespectLink.class);
                } else {
                    this.respectMap.put((String)field, clazz);
                }
                if (this.respectMap.containsKey(field)) {
                    JsonObject query = Ut.valueJObject((JsonObject)config, (String)"query");
                    query.put("", (Object)Boolean.TRUE);
                    this.queryMap.put((String)field, query);
                }
            }
        });
    }

    public Set<String> fields() {
        return this.respectMap.keySet();
    }

    public Respect respect(String field) {
        JsonObject query = this.queryMap.getOrDefault(field, new JsonObject());
        Class respectCls = (Class)this.respectMap.get(field);
        String hashKey = Ut.encryptMD5((String)(field + query.hashCode() + respectCls.getName()));
        return (Respect)CC_RESPECT.pick(() -> (Respect)Ut.instance((Class)respectCls, (Object[])new Object[]{query}), (Object)hashKey);
    }
}

