/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.workflow.atom;

import cn.vertxup.workflow.cv.WfPool;
import cn.vertxup.workflow.domain.tables.pojos.WFlow;
import io.aeon.experiment.specification.KFlow;
import io.vertx.tp.error._404WorkflowNullException;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.atom.runtime.WRequest;
import io.vertx.tp.workflow.init.WfPin;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.central.Behaviour;
import io.vertx.tp.workflow.uca.coadjutor.Stay;
import io.vertx.tp.workflow.uca.coadjutor.StayCancel;
import io.vertx.tp.workflow.uca.coadjutor.StayClose;
import io.vertx.tp.workflow.uca.coadjutor.StaySave;
import io.vertx.tp.workflow.uca.component.Movement;
import io.vertx.tp.workflow.uca.component.MovementEmpty;
import io.vertx.tp.workflow.uca.component.MovementStay;
import io.vertx.tp.workflow.uca.component.Transfer;
import io.vertx.tp.workflow.uca.component.TransferEmpty;
import io.vertx.tp.workflow.uca.component.TransferStandard;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Supplier;

public class EngineOn {
    private final transient WFlow workflow;
    private final transient MetaInstance metadata;

    private EngineOn(WFlow workflow) {
        Objects.requireNonNull(workflow);
        this.workflow = workflow;
        this.metadata = MetaInstance.input(Ut.toJObject((String)workflow.getStartConfig()), Ut.toJObject((String)workflow.getUiLinkage()));
    }

    public static EngineOn connect(String definitionKey) {
        Objects.requireNonNull(definitionKey);
        Wf.LOG.Web.info(EngineOn.class, "The system will detect `{0}` workflow.", new Object[]{definitionKey});
        return (EngineOn)WfPool.CC_ENGINE.pick(() -> {
            WFlow flow = WfPin.getFlow(definitionKey);
            Fn.out((boolean)Objects.isNull(flow), _404WorkflowNullException.class, (Object[])new Object[]{EngineOn.class, definitionKey});
            return new EngineOn(flow);
        }, (Object)definitionKey);
    }

    public static EngineOn connect(WRequest request) {
        KFlow key = request.workflow();
        return EngineOn.connect(key.definitionKey());
    }

    public Transfer componentStart() {
        return this.component(this.workflow::getStartComponent, this.workflow.getStartConfig(), () -> (Transfer)Ut.singleton(TransferEmpty.class, (Object[])new Object[0]));
    }

    public Transfer componentGenerate() {
        return this.component(this.workflow::getGenerateComponent, this.workflow.getGenerateConfig(), this::transferStandard);
    }

    public Movement componentRun() {
        return this.component(this.workflow::getRunComponent, this.workflow.getRunConfig(), () -> (Movement)Ut.singleton(MovementEmpty.class, (Object[])new Object[0]));
    }

    public Movement stayMovement() {
        return (Movement)this.component(MovementStay.class, null);
    }

    public Stay stayDraft() {
        return (Stay)this.component(StaySave.class, null);
    }

    public Stay stayCancel() {
        return (Stay)this.component(StayCancel.class, null);
    }

    public Stay stayClose() {
        return (Stay)this.component(StayClose.class, null);
    }

    private Transfer transferStandard() {
        return (Transfer)this.component(TransferStandard.class, this.workflow.getGenerateComponent());
    }

    private <C extends Behaviour> C component(Supplier<String> componentCls, String componentValue, Supplier<C> defaultCls) {
        Class clazz = Ut.clazz((String)componentCls.get(), null);
        if (Objects.isNull(clazz)) {
            return (C)((Behaviour)defaultCls.get());
        }
        return this.component(clazz, componentValue);
    }

    private <C extends Behaviour> C component(Class<?> clazz, String componentValue) {
        String keyComponent = this.metadata.recordComponentKey(clazz, componentValue);
        return (C)((Behaviour)WfPool.CC_COMPONENT.pick(() -> {
            Behaviour instance = (Behaviour)Ut.instance((Class)clazz, (Object[])new Object[0]);
            instance.bind(Ut.toJObject((String)componentValue)).bind(this.metadata);
            return instance;
        }, (Object)keyComponent));
    }

    public MetaInstance metadata() {
        Objects.requireNonNull(this.metadata);
        return this.metadata;
    }
}

