/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.workflow.service;

import cn.vertxup.workflow.domain.tables.daos.WTicketDao;
import cn.vertxup.workflow.domain.tables.daos.WTodoDao;
import cn.vertxup.workflow.domain.tables.pojos.WTicket;
import cn.vertxup.workflow.domain.tables.pojos.WTodo;
import cn.vertxup.workflow.service.AclStub;
import cn.vertxup.workflow.service.TaskStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.atom.EngineOn;
import io.vertx.tp.workflow.atom.configuration.MetaInstance;
import io.vertx.tp.workflow.atom.runtime.WRecord;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.toolkit.ULinkage;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import javax.inject.Inject;

public class TaskService
implements TaskStub {
    @Inject
    private transient AclStub aclStub;

    @Override
    public Future<JsonObject> fetchQueue(JsonObject condition) {
        JsonObject combine = Ux.irAndQH((JsonObject)condition, (String)"flowEnd", (Object)Boolean.FALSE);
        return Ux.Join.on().add(WTodoDao.class, "traceId").join(WTicketDao.class).alias(WTicketDao.class, new JsonObject().put("key", (Object)"traceKey").put("serial", (Object)"traceSerial").put("code", (Object)"traceCode")).searchAsync(combine);
    }

    @Override
    public Future<JsonObject> fetchHistory(JsonObject condition) {
        JsonObject combine = Ux.irAndQH((JsonObject)condition, (String)"flowEnd", (Object)Boolean.TRUE);
        return Ux.Jooq.on(WTicketDao.class).searchAsync(combine);
    }

    @Override
    public Future<JsonObject> readPending(String key, String userId) {
        WRecord record = WRecord.create();
        return this.readTodo(key, record).compose(processed -> {
            WTodo todo = processed.task();
            if (Objects.isNull(todo)) {
                Wf.LOG.Web.info(this.getClass(), "Ticket Status Conflict, key = {0}", new Object[]{key});
                return Ux.futureJ();
            }
            return Ux.future((Object)todo.getTraceId()).compose(ticketId -> this.readTicket((String)ticketId, record)).compose(ULinkage::readLinkage).compose(this::readChild).compose(wData -> wData.futureJ(false)).compose(response -> this.aclStub.authorize(record, userId).compose(acl -> Ux.future((Object)response.put("__acl", acl))));
        });
    }

    private Future<WRecord> readTodo(String key, WRecord response) {
        return Ux.Jooq.on(WTodoDao.class).fetchByIdAsync((Object)key).compose(Fn.ifNil(response::bind, todo -> Ux.future((Object)response.task((WTodo)todo))));
    }

    private Future<WRecord> readTicket(String key, WRecord response) {
        return Ux.Jooq.on(WTicketDao.class).fetchByIdAsync((Object)key).compose(Fn.ifNil(response::bind, ticket -> Ux.future((Object)response.ticket((WTicket)ticket))));
    }

    private Future<WRecord> readChild(WRecord response) {
        WTicket ticket = response.ticket();
        Objects.requireNonNull(ticket);
        EngineOn engine = EngineOn.connect(ticket.getFlowDefinitionKey());
        MetaInstance meta = engine.metadata();
        UxJooq jq = meta.childDao();
        if (Objects.isNull(jq)) {
            return Ux.future((Object)response);
        }
        return jq.fetchJByIdAsync((Object)ticket.getKey()).compose(queried -> Ux.future((Object)meta.childOut((JsonObject)queried))).compose(queried -> Ux.future((Object)response.ticket((JsonObject)queried)));
    }

    @Override
    public Future<JsonObject> readFinished(String key) {
        WRecord record = WRecord.create();
        return this.readTicket(key, record).compose(ULinkage::readLinkage).compose(this::readChild).compose(wData -> wData.futureJ(true));
    }
}

