/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.workflow.service;

import cn.vertxup.workflow.domain.tables.daos.WFlowDao;
import cn.vertxup.workflow.service.FlowStub;
import io.horizon.spi.ui.Form;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.camunda.Io;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

public class FlowService
implements FlowStub {
    @Override
    public Future<JsonObject> fetchFlow(String definitionKey, String sigma) {
        Io<StartEvent> io = Io.ioEventStart();
        JsonObject workflowJ = new JsonObject();
        ProcessDefinition definition = io.inProcess(definitionKey);
        workflowJ.mergeIn(Wf.outBpmn(definition), true);
        return io.children(definition.getId()).compose(starts -> io.out(workflowJ, (List<StartEvent>)starts)).compose(definitionJ -> this.flowInternal(definitionKey, sigma).compose(workflow -> {
            JsonObject response = new JsonObject();
            response.mergeIn(workflow);
            response.mergeIn(definitionJ);
            Ut.valueToJObject((JsonObject)response, (String[])new String[]{"startConfig", "authorizedConfig", "endConfig", "runConfig", "generateConfig", "uiConfig", "uiAssist", "uiLinkage"});
            JsonObject linkageJ = Ut.valueJObject((JsonObject)response, (String)"uiLinkage");
            response.put("uiLinkage", (Object)Wf.outLinkage(linkageJ));
            return Ux.future((Object)response);
        }));
    }

    @Override
    public Future<JsonObject> fetchForm(ProcessDefinition definition, String sigma) {
        Io<JsonObject> ioForm = Io.ioForm();
        Io<JsonObject> ioFlow = Io.ioFlow();
        JsonObject response = new JsonObject();
        return Ux.future((Object)definition).compose(x$0 -> ioForm.start((ProcessDefinition)x$0)).compose(formInput -> this.formInternal((JsonObject)formInput, sigma)).compose(formOutput -> ioForm.out(response, (JsonObject)formOutput)).compose(nil -> ioFlow.start(definition)).compose(workflow -> ioFlow.out(response, (JsonObject)workflow));
    }

    @Override
    public Future<JsonObject> fetchForm(ProcessInstance instance, Task task, String sigma) {
        JsonObject response = new JsonObject();
        Io<JsonObject> ioForm = Io.ioForm();
        Io<JsonObject> ioFlow = Io.ioFlow();
        return Ux.future((Object)task).compose(x$0 -> ioForm.run((Task)x$0)).compose(formInput -> this.formInternal((JsonObject)formInput, sigma)).compose(formOutput -> ioForm.out(response, (JsonObject)formOutput)).compose(nil -> ioFlow.run(task)).compose(workflow -> ioFlow.out(response, (JsonObject)workflow));
    }

    @Override
    public Future<JsonObject> fetchForm(HistoricProcessInstance instance, String sigma) {
        JsonObject response = new JsonObject();
        Io<JsonObject> ioForm = Io.ioForm();
        Io<JsonObject> ioFlow = Io.ioFlow();
        return Ux.future((Object)instance).compose(x$0 -> ioForm.end((HistoricProcessInstance)x$0)).compose(formInput -> this.formInternal((JsonObject)formInput, sigma)).compose(formOutput -> ioForm.out(response, (JsonObject)formOutput)).compose(nil -> ioFlow.end(instance)).compose(workflow -> ioFlow.out(response, (JsonObject)workflow));
    }

    private Future<JsonObject> flowInternal(String definitionKey, String sigma) {
        JsonObject condition = Ux.whereAnd();
        condition.put("code", (Object)definitionKey);
        condition.put("sigma", (Object)sigma);
        return Ux.Jooq.on(WFlowDao.class).fetchJOneAsync(condition);
    }

    private Future<JsonObject> formInternal(JsonObject formInput, String sigma) {
        JsonObject parameters = formInput.copy();
        parameters.put("sigma", (Object)sigma);
        return Ux.channel(Form.class, JsonObject::new, stub -> stub.fetchUi(parameters));
    }
}

