/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.workflow.api;

import cn.vertxup.workflow.domain.tables.daos.WTicketDao;
import cn.vertxup.workflow.service.FlowStub;
import cn.vertxup.workflow.service.TaskStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.tp.error._404ProcessMissingException;
import io.vertx.tp.workflow.refine.Wf;
import io.vertx.tp.workflow.uca.camunda.Io;
import io.vertx.tp.workflow.uca.conformity.GVm;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.commune.config.XHeader;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import javax.inject.Inject;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;

@Queue
public class QueueActor {
    @Inject
    private transient FlowStub flowStub;
    @Inject
    private transient TaskStub taskStub;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-TODO/TASK/QUEUE")
    public Future<JsonObject> fetchQueue(JsonObject qr) {
        Wf.LOG.Queue.info(this.getClass(), "Qr Queue Input: {0}", new Object[]{qr.encode()});
        JsonObject qrStatus = Ux.whereAnd();
        qrStatus.put("status,i", (Object)GVm.Status.QUEUE);
        JsonObject qrCombine = Ux.irAndQH((JsonObject)qr, (String)"$Q$", (Object)qrStatus);
        Wf.LOG.Queue.info(this.getClass(), "Qr Queue Combined: {0}", new Object[]{qrCombine.encode()});
        return this.taskStub.fetchQueue(qrCombine);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-TICKET/TICKET/HISTORY")
    public Future<JsonObject> fetchHistory(JsonObject qr) {
        return this.taskStub.fetchHistory(qr);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-FLOW/BY/CODE")
    public Future<JsonObject> fetchFlow(String code, XHeader header) {
        String sigma = header.getSigma();
        return this.flowStub.fetchFlow(code, sigma);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-TODO/TASK/VIRTUAL-FORM")
    public Future<JsonObject> fetchForm(JsonObject data, Boolean isPre, XHeader header) {
        String definitionId = data.getString("definitionId");
        Io<Task> ioTask = Io.ioTask();
        ProcessDefinition definition = ioTask.inProcess(definitionId);
        if (Objects.isNull(definition)) {
            return Fn.outWeb(_404ProcessMissingException.class, (Object[])new Object[]{this.getClass(), definitionId});
        }
        String sigma = header.getSigma();
        if (isPre.booleanValue()) {
            return this.flowStub.fetchForm(definition, sigma);
        }
        String instanceId = data.getString("instanceId");
        ProcessInstance instance = ioTask.inInstance(instanceId);
        if (Objects.isNull(instance)) {
            HistoricProcessInstance instanceHistory = ioTask.inHistoric(instanceId);
            return this.flowStub.fetchForm(instanceHistory, sigma);
        }
        String taskId = data.getString("taskId");
        return ioTask.run(taskId).compose(task -> {
            if (Objects.isNull(task)) {
                return Ux.futureJ();
            }
            return this.flowStub.fetchForm(instance, (Task)task, sigma);
        });
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-FLOW/BY/KEY")
    public Future<JsonObject> fetchTodo(String key, User user) {
        String userId = Ux.keyUser((User)user);
        return this.taskStub.readPending(key, userId);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-FLOW/BY/HISTORY")
    public Future<JsonObject> fetchHistory(String key) {
        return this.taskStub.readFinished(key);
    }

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03a1\u03bf\u03ae \u03b5\u03c1\u03b3\u03b1\u03c3\u03af\u03b1\u03c2/W-TICKET/TICKET/LINKAGE")
    public Future<JsonObject> searchTicket(JsonObject query) {
        return Ux.Jooq.on(WTicketDao.class).searchAsync(query);
    }
}

