-- liquibase formatted sql

-- changeset Lang:ox-field-1
-- 字段表：UI_FIELD，表单专用，CONTROL中的 type = FORM 类型
DROP TABLE IF EXISTS UI_FIELD;
CREATE TABLE IF NOT EXISTS UI_FIELD
(
    `KEY`           VARCHAR(36) COMMENT '「key」- 字段主键',
    `X_POINT`       INTEGER COMMENT '「xPoint] - 字段的X坐标（列）',
    `Y_POINT`       INTEGER COMMENT '「yPoint」- 字段的Y坐标（行）',
    `LABEL`         VARCHAR(255) COMMENT '「label」- 字段标签',
    `NAME`          VARCHAR(255) COMMENT '「name」- 字段名称',
    `SPAN`          INTEGER COMMENT '「span」- 字段宽度',
    `RENDER`        VARCHAR(64) COMMENT '「render」- 使用的Render函数',
    -- Option选项
    `OPTION_JSX`    TEXT COMMENT '「optionJsx」- 字段专用配置',
    `OPTION_CONFIG` TEXT COMMENT '「optionConfig」- 字段专用配置',
    `OPTION_ITEM`   TEXT COMMENT '「optionItem」- 字段专用配置',
    `RULES`         TEXT COMMENT '「rules」- 专用的配置，描述规则',
    -- 事件配置
    `DATA_EVENT`    TEXT COMMENT '「dataEvent」- 当前字段的事件配置，只有名称为 $button 时生效',
    -- 系统数据
    `FORM_ID`       VARCHAR(36) COMMENT '「formId」- 关联的表单ID',

    -- 特殊字段
    `ACTIVE`        BIT         DEFAULT NULL COMMENT '「active」- 是否启用',
    `SIGMA`         VARCHAR(32) DEFAULT NULL COMMENT '「sigma」- 统一标识',
    `METADATA`      TEXT COMMENT '「metadata」- 附加配置',
    `LANGUAGE`      VARCHAR(8)  DEFAULT NULL COMMENT '「language」- 使用的语言',

    -- Auditor字段
    `CREATED_AT`    DATETIME COMMENT '「createdAt」- 创建时间',
    `CREATED_BY`    VARCHAR(36) COMMENT '「createdBy」- 创建人',
    `UPDATED_AT`    DATETIME COMMENT '「updatedAt」- 更新时间',
    `UPDATED_BY`    VARCHAR(36) COMMENT '「updatedBy」- 更新人',
    PRIMARY KEY (`KEY`)
);
-- changeset Lang:ox-field-2
ALTER TABLE UI_FIELD
    ADD UNIQUE (`FORM_ID`, `NAME`);