/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ui.init;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ui.atom.UiConfig;
import io.vertx.tp.ui.refine.Ui;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class UiConfiguration {
    private static final Annal LOGGER = Annal.get(UiConfiguration.class);
    private static final ConcurrentMap<String, JsonArray> COLUMN_MAP = new ConcurrentHashMap<String, JsonArray>();
    private static UiConfig CONFIG = null;

    UiConfiguration() {
    }

    static void init() {
        if (null == CONFIG) {
            JsonObject uiData = Ut.ioJObject((String)"plugin/ui/configuration.json");
            Ui.infoInit(LOGGER, "Ui Json Data: {0}", uiData.encode());
            CONFIG = (UiConfig)Ut.deserialize((JsonObject)uiData, UiConfig.class);
            Ui.infoInit(LOGGER, "Ui Configuration: {0}", CONFIG.toString());
            UiConfiguration.initColumn(CONFIG);
            Ui.infoInit(LOGGER, "Ui Columns: Size = {0}", COLUMN_MAP.size());
        }
    }

    static UiConfig getConfig() {
        return CONFIG;
    }

    private static void initColumn(UiConfig config) {
        JsonObject mapping = config.getMapping();
        if (!Ut.isNil((JsonObject)mapping)) {
            String configPath = config.getDefinition();
            mapping.fieldNames().forEach(fileKey -> {
                String file = mapping.getString(fileKey);
                String filePath = configPath + '/' + file;
                JsonArray columns = Ut.ioJArray((String)filePath);
                if (Objects.nonNull(columns) && !columns.isEmpty()) {
                    COLUMN_MAP.put((String)fileKey, columns);
                }
            });
        }
    }

    static JsonArray getColumn(String key) {
        return COLUMN_MAP.getOrDefault(key, new JsonArray());
    }
}

