/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.refine;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.Orbit;
import io.vertx.tp.optic.Pocket;
import io.vertx.tp.optic.atom.Income;
import io.vertx.tp.rbac.permission.ScHabitus;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

class ScPhase {
    private static final Annal LOGGER = Annal.get(ScPhase.class);

    ScPhase() {
    }

    static String uri(String uri, String requestUri) {
        return (String)Ke.channelSync(Orbit.class, () -> uri, orbit -> {
            Income income = Pocket.income(Orbit.class, (Object[])new Object[]{uri, requestUri});
            return orbit.analyze(income.arguments());
        });
    }

    static String uri(RoutingContext context) {
        HttpServerRequest request = context.request();
        HttpMethod method = request.method();
        String requestUri = ZeroAnno.recoveryUri((String)request.path(), (HttpMethod)method);
        return ScPhase.uri(requestUri, request.path());
    }

    private static String cacheKey(RoutingContext context) {
        HttpServerRequest request = context.request();
        String uri = ScPhase.uri(context);
        Sc.debugAuth(LOGGER, "Processed Uri: {0}", uri);
        String cacheKey = Ke.keySession((String)request.method().name(), (String)uri);
        Sc.debugAuth(LOGGER, "Try cacheKey: {0}", cacheKey);
        return cacheKey;
    }

    static Future<JsonObject> cacheBound(RoutingContext context, Envelop envelop) {
        String habit = Ke.keyHabitus((Envelop)envelop);
        if (Ut.isNil((String)habit)) {
            return Ux.future((Object)new JsonObject());
        }
        ScHabitus habitus = ScHabitus.initialize(habit);
        String cacheKey = ScPhase.cacheKey(context);
        return habitus.get(cacheKey);
    }
}

