/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.extension;

import io.vertx.core.Future;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.rbac.acl.region.CommonCosmo;
import io.vertx.tp.rbac.acl.region.Cosmo;
import io.vertx.tp.rbac.acl.region.SeekCosmo;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.Envelop;
import io.vertx.up.extension.region.AbstractRegion;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DataRegion
extends AbstractRegion {
    private static final ConcurrentMap<String, Cosmo> POOL_COMMON = new ConcurrentHashMap<String, Cosmo>();
    private static final ConcurrentMap<String, Cosmo> POOL_SEEK = new ConcurrentHashMap<String, Cosmo>();

    public Future<Envelop> before(RoutingContext context, Envelop envelop) {
        if (this.isEnabled(context)) {
            return Sc.cacheBound(context, envelop).compose(matrix -> {
                if (Objects.nonNull(matrix)) {
                    Sc.infoAuth(this.getLogger(), context.request().path(), "--> DataRegion Before: uri = {0}, region = {1}git", matrix.encode());
                    HttpMethod method = envelop.method();
                    if (HttpMethod.POST == method || HttpMethod.GET == method) {
                        Cosmo cosmo = this.cosmo((JsonObject)matrix);
                        return cosmo.before(envelop, (JsonObject)matrix);
                    }
                    return Ux.future((Object)envelop);
                }
                return Ux.future((Object)envelop);
            });
        }
        return Ux.future((Object)envelop);
    }

    public Future<Envelop> after(RoutingContext context, Envelop response) {
        if (this.isEnabled(context)) {
            return Sc.cacheBound(context, response).compose(matrix -> {
                if (Objects.nonNull(matrix)) {
                    Sc.infoAuth(this.getLogger(), "<-- DataRegion After: {0}", matrix.encode());
                    Cosmo cosmo = this.cosmo((JsonObject)matrix);
                    return cosmo.after(response, (JsonObject)matrix);
                }
                return Ux.future((Object)response);
            });
        }
        return Ux.future((Object)response);
    }

    private Cosmo cosmo(JsonObject matrix) {
        if (matrix.containsKey("seeker")) {
            return (Cosmo)Fn.poolThread(POOL_SEEK, SeekCosmo::new);
        }
        return (Cosmo)Fn.poolThread(POOL_COMMON, CommonCosmo::new);
    }
}

