/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authorization.extend;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.atom.ProfileGroup;
import io.vertx.tp.rbac.atom.ProfileRole;
import io.vertx.tp.rbac.atom.ProfileType;
import io.vertx.tp.rbac.authorization.Align;
import io.vertx.tp.rbac.authorization.Amalgam;
import io.vertx.tp.rbac.authorization.Assembler;
import io.vertx.tp.rbac.authorization.ScDetent;
import java.util.List;

public class GeCritical
implements ScDetent {
    private final transient List<ProfileGroup> original;

    public GeCritical(List<ProfileGroup> original) {
        this.original = original;
    }

    private List<ProfileRole> before(List<ProfileRole> profiles) {
        ProfileGroup eager = Align.eager(this.original);
        List<ProfileRole> source = Amalgam.children(profiles, eager);
        List<ProfileRole> processed = Amalgam.eager(source);
        return Assembler.connect(processed, eager);
    }

    @Override
    public JsonObject proc(List<ProfileRole> profiles) {
        JsonObject group = new JsonObject();
        List<ProfileRole> source = this.before(profiles);
        Amalgam.logGroup(this.getClass(), source);
        Assembler.union(ProfileType.EXTEND_CRITICAL_UNION, source).accept(group);
        Assembler.eager(ProfileType.EXTEND_CRITICAL_EAGER, source).accept(group);
        Assembler.lazy(ProfileType.EXTEND_CRITICAL_LAZY, source).accept(group);
        Assembler.intersect(ProfileType.EXTEND_CRITICAL_INTERSECT, source).accept(group);
        return group;
    }
}

