/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.authorization;

import io.vertx.tp.rbac.atom.ProfileGroup;
import io.vertx.tp.rbac.atom.ProfileRole;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Amalgam {
    public static void logGroup(Class<?> clazz, List<ProfileRole> roles) {
        Annal LOGGER = Annal.get(clazz);
        Sc.debugAuth(LOGGER, "Group Selected: {0}, Size: {1}", Ut.fromJoin(Amalgam.getGroups(roles)), String.valueOf(roles.size()));
    }

    public static List<ProfileRole> parent(List<ProfileRole> roles, ProfileGroup group) {
        return new ArrayList<ProfileRole>(roles).stream().filter(role -> Objects.nonNull(role.getGroup())).filter(role -> group.getReference().equals(role.getGroup().getKey())).collect(Collectors.toList());
    }

    public static List<ProfileRole> children(List<ProfileRole> roles, ProfileGroup group) {
        return new ArrayList<ProfileRole>(roles).stream().filter(role -> Objects.nonNull(role.getGroup())).filter(role -> group.getKey().equals(role.getGroup().getReference())).collect(Collectors.toList());
    }

    public static List<ProfileRole> eagerEach(List<ProfileRole> roles) {
        return Amalgam.getGroups(roles).stream().map(group -> roles.stream().filter(role -> group.equals(role.getGroup().getKey())).min(Comparator.comparing(ProfileRole::getPriority)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<ProfileRole> lazyEach(List<ProfileRole> roles) {
        return Amalgam.getGroups(roles).stream().map(group -> roles.stream().filter(role -> group.equals(role.getGroup().getKey())).max(Comparator.comparing(ProfileRole::getPriority)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<ProfileRole> eager(List<ProfileRole> roles) {
        Integer groupPriority = Amalgam.findGroupPriority(roles, true);
        return roles.stream().filter(role -> groupPriority.equals(role.getGroup().getPriority())).collect(Collectors.toList());
    }

    public static List<ProfileRole> lazy(List<ProfileRole> roles) {
        Integer groupPriority = Amalgam.findGroupPriority(roles, false);
        return roles.stream().filter(role -> groupPriority.equals(role.getGroup().getPriority())).collect(Collectors.toList());
    }

    private static Integer findGroupPriority(List<ProfileRole> roles, boolean isHigh) {
        return isHigh ? roles.stream().map(ProfileRole::getGroup).min(Comparator.comparing(ProfileGroup::getPriority)).map(ProfileGroup::getPriority).orElse(0) : roles.stream().map(ProfileRole::getGroup).max(Comparator.comparing(ProfileGroup::getPriority)).map(ProfileGroup::getPriority).orElse(Integer.MAX_VALUE);
    }

    private static Set<String> getGroups(List<ProfileRole> roles) {
        return roles.stream().map(ProfileRole::getGroup).map(ProfileGroup::getKey).collect(Collectors.toSet());
    }
}

