/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.acl.region;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.acl.rapid.Dwarf;
import io.vertx.tp.rbac.cv.em.RegionType;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.Envelop;
import io.vertx.up.commune.secure.Acl;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

class DataOut {
    private static final Annal LOGGER = Annal.get(DataOut.class);

    DataOut() {
    }

    static void dwarfRecord(Envelop envelop, JsonObject matrix) {
        Acl acl = envelop.acl();
        JsonArray projection = Sc.aclOn(matrix.getJsonArray("projection"), acl);
        DataOut.dwarfUniform(envelop, projection, (Set<RegionType>)new HashSet<RegionType>(){
            {
                this.add(RegionType.RECORD);
            }
        }, (responseJson, type) -> Dwarf.create(type).minimize((JsonObject)responseJson, matrix, acl));
    }

    static void dwarfRows(Envelop envelop, JsonObject matrix) {
        JsonObject rows = matrix.getJsonObject("rows");
        DataOut.dwarfUniform(envelop, rows, (Set<RegionType>)new HashSet<RegionType>(){
            {
                this.add(RegionType.ARRAY);
                this.add(RegionType.PAGINATION);
            }
        }, (responseJson, type) -> Dwarf.create(type).minimize((JsonObject)responseJson, matrix, envelop.acl()));
    }

    static void dwarfCollection(Envelop envelop, JsonObject matrix) {
        JsonArray prjection = Sc.aclOn(matrix.getJsonArray("projection"), envelop.acl());
        DataOut.dwarfUniform(envelop, prjection, (Set<RegionType>)new HashSet<RegionType>(){
            {
                this.add(RegionType.ARRAY);
                this.add(RegionType.PAGINATION);
            }
        }, (responseJson, type) -> Dwarf.create(type).minimize((JsonObject)responseJson, matrix, envelop.acl()));
    }

    private static <T> void dwarfUniform(Envelop envelop, T hitted, Set<RegionType> expected, BiConsumer<JsonObject, RegionType> consumer) {
        if (Objects.nonNull(hitted)) {
            JsonObject responseJson;
            Supplier<Boolean> isEmpty = null;
            if (hitted instanceof JsonObject) {
                isEmpty = () -> ((JsonObject)((JsonObject)hitted)).isEmpty();
            } else if (hitted instanceof JsonArray) {
                isEmpty = () -> ((JsonArray)((JsonArray)hitted)).isEmpty();
            }
            if (Objects.nonNull(isEmpty) && !isEmpty.get().booleanValue() && Objects.nonNull(responseJson = envelop.outJson())) {
                RegionType type = DataOut.analyzeRegion(responseJson);
                Sc.infoAuth(LOGGER, "DataRegion Analyzed type: {0}, data = {1}", new Object[]{type, responseJson.encode()});
                if (expected.contains((Object)type)) {
                    consumer.accept(responseJson, type);
                }
            }
        }
    }

    private static RegionType analyzeRegion(JsonObject reference) {
        Object value = reference.getValue("data");
        if (Objects.nonNull(value)) {
            if (Ut.isJArray((Object)value)) {
                return RegionType.ARRAY;
            }
            if (Ut.isJObject((Object)value)) {
                JsonObject json = (JsonObject)value;
                if (json.containsKey("list") && json.containsKey("count") && 2 == json.size()) {
                    return RegionType.PAGINATION;
                }
                return RegionType.RECORD;
            }
            return RegionType.FORBIDDEN;
        }
        return RegionType.FORBIDDEN;
    }
}

