/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.business;

import cn.vertxup.rbac.domain.tables.daos.SPermSetDao;
import cn.vertxup.rbac.domain.tables.daos.SPermissionDao;
import cn.vertxup.rbac.domain.tables.pojos.SPermSet;
import cn.vertxup.rbac.domain.tables.pojos.SPermission;
import cn.vertxup.rbac.service.business.PermGStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.Refer;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class PermGService
implements PermGStub {
    @Override
    public Future<JsonArray> fetchAsync(String sigma) {
        JsonObject condition = new JsonObject();
        condition.put("sigma", sigma);
        return Ux.Jooq.on(SPermSetDao.class).fetchJAsync(condition);
    }

    @Override
    public Future<JsonArray> saveDefinition(JsonArray permissions, SPermSet permSet) {
        String sigma = permSet.getSigma();
        Refer permSetRef = new Refer();
        Refer mapRef = new Refer();
        return this.calcPermission(permissions, sigma).compose(arg_0 -> ((Refer)mapRef).future(arg_0)).compose(compared -> {
            ArrayList<Future> combined = new ArrayList<Future>();
            UxJooq jooq = Ux.Jooq.on(SPermissionDao.class);
            combined.add(jooq.insertAsync((List)compared.get(ChangeFlag.ADD)));
            combined.add(jooq.updateAsync((List)compared.get(ChangeFlag.UPDATE)));
            return Ux.thenCombineArrayT(combined).compose(processed -> permSetRef.future(processed.stream().map(SPermission::getCode).collect(Collectors.toSet())));
        }).compose(nil -> {
            JsonObject criteria = new JsonObject();
            criteria.put("sigma", sigma);
            criteria.put("name", permSet.getName());
            return Ux.Jooq.on(SPermSetDao.class).fetchAndAsync(criteria);
        }).compose(originalSet -> {
            Set current = (Set)permSetRef.get();
            Set original = originalSet.stream().map(SPermSet::getCode).collect(Collectors.toSet());
            Set added = Ut.diff((Set)current, original);
            Set updated = Ut.intersect((Set)current, original);
            ArrayList<Future<List<SPermSet>>> futures = new ArrayList<Future<List<SPermSet>>>();
            futures.add(this.insertPerm(permSet, added));
            futures.add(this.updatePerm(permSet, (List<SPermSet>)originalSet, updated));
            ConcurrentMap map = (ConcurrentMap)mapRef.get();
            List deleted = (List)map.get(ChangeFlag.DELETE);
            futures.add(this.deletePerm(permSet, deleted));
            return Ux.thenCombineArrayT(futures);
        }).compose(Ux::futureA);
    }

    private Future<List<SPermSet>> deletePerm(SPermSet permSet, List<SPermission> permissions) {
        JsonObject criteria = new JsonObject();
        criteria.put("sigma", permSet.getSigma());
        criteria.put("name", permSet.getName());
        criteria.put("code,i", Ut.toJArray(permissions.stream().map(SPermission::getCode).collect(Collectors.toSet())));
        criteria.put("", Boolean.TRUE);
        return Ux.Jooq.on(SPermSetDao.class).deleteByAsync(criteria).compose(nil -> Ux.future(new ArrayList()));
    }

    private Future<List<SPermSet>> updatePerm(SPermSet permSet, List<SPermSet> permSetList, Set<String> codes) {
        permSetList.forEach(each -> {
            each.setUpdatedBy(permSet.getUpdatedBy());
            each.setUpdatedAt(permSet.getUpdatedAt());
        });
        return Ux.Jooq.on(SPermSetDao.class).updateAsync(permSetList.stream().filter(item -> codes.contains(item.getCode())).collect(Collectors.toList()));
    }

    private Future<List<SPermSet>> insertPerm(SPermSet permSet, Set<String> codes) {
        ArrayList list = new ArrayList();
        codes.forEach(each -> {
            SPermSet inserted = new SPermSet();
            inserted.setKey(UUID.randomUUID().toString());
            inserted.setCode((String)each);
            inserted.setType(permSet.getType());
            inserted.setName(permSet.getName());
            inserted.setActive(Boolean.TRUE);
            inserted.setSigma(permSet.getSigma());
            inserted.setLanguage(permSet.getLanguage());
            inserted.setCreatedAt(LocalDateTime.now());
            inserted.setCreatedBy(permSet.getUpdatedBy());
            list.add(inserted);
        });
        return Ux.Jooq.on(SPermSetDao.class).insertAsync(list);
    }

    private Future<ConcurrentMap<ChangeFlag, List<SPermission>>> calcPermission(JsonArray permissions, String sigma) {
        Set permCodes = Ut.mapString((JsonArray)permissions, (String)"code");
        JsonObject criteria = new JsonObject();
        criteria.put("sigma", sigma);
        criteria.put("code,i", Ut.toJArray((Set)permCodes));
        return Ux.Jooq.on(SPermissionDao.class).fetchAndAsync(criteria).compose(original -> {
            List current = Ux.fromJson((JsonArray)permissions, SPermission.class);
            return Ux.future((Object)Ux.compare((List)original, (List)current, SPermission::getKey));
        });
    }
}

