/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.accredit;

import cn.vertxup.rbac.domain.tables.pojos.SAction;
import cn.vertxup.rbac.domain.tables.pojos.SResource;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._403ActionDinnedException;
import io.vertx.tp.error._403ActionMissingException;
import io.vertx.tp.error._403NoPermissionException;
import io.vertx.tp.error._403PermissionLimitException;
import io.vertx.tp.error._404ResourceMissingException;
import io.vertx.tp.rbac.atom.ScRequest;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.commune.secure.DataBound;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.log.Annal;
import java.util.Objects;

class AccreditFlow {
    private static final Annal LOGGER = Annal.get(AccreditFlow.class);

    AccreditFlow() {
    }

    static Future<SAction> inspectAction(Class<?> clazz, SAction action, ScRequest request) {
        if (Objects.isNull(action)) {
            String requestUri = request.getMethod() + " " + request.getNormalizedUri();
            _403ActionMissingException error = new _403ActionMissingException(clazz, requestUri);
            return Future.failedFuture((Throwable)((Object)error));
        }
        Sc.debugCredit(LOGGER, "1. Accredit action ( uri = `{0}`, method = `{1}`, normalizedUri = `{2}` ).", request.getRequestUri(), request.getMethod(), request.getNormalizedUri());
        return Future.succeededFuture((Object)action);
    }

    static Future<SResource> inspectResource(Class<?> clazz, SResource resource, ScRequest request, SAction action) {
        if (Objects.isNull(resource)) {
            String requestUri = request.getMethod() + " " + request.getNormalizedUri();
            _404ResourceMissingException error = new _404ResourceMissingException(clazz, action.getResourceId(), requestUri);
            return Future.failedFuture((Throwable)((Object)error));
        }
        Sc.debugCredit(LOGGER, "2. Accredit resource ( resource = `{0}` ).", resource.getKey());
        return Future.succeededFuture((Object)resource);
    }

    static Future<SResource> inspectLevel(Class<?> clazz, SResource resource, SAction action) {
        Integer required = resource.getLevel();
        Integer actual = action.getLevel();
        if (actual < required) {
            _403ActionDinnedException error = new _403ActionDinnedException(clazz, required, actual);
            return Future.failedFuture((Throwable)((Object)error));
        }
        Sc.debugCredit(LOGGER, "3. Accredit level ( action = {0}, resource = {1} ).", action.getLevel(), resource.getLevel());
        return Future.succeededFuture((Object)resource);
    }

    static Future<JsonArray> inspectPermission(Class<?> clazz, SResource resource, ScRequest request) {
        String profileKey = Sc.generateProfileKey(resource);
        return request.openSession().compose(privilege -> privilege.fetchPermissions(profileKey)).compose(permissions -> {
            if (Objects.isNull(permissions) || permissions.isEmpty()) {
                _403NoPermissionException error = new _403NoPermissionException(clazz, request.getUser(), profileKey);
                return Future.failedFuture((Throwable)((Object)error));
            }
            Sc.debugCredit(LOGGER, "4. Accredit profile ( profileKey = {0} ).", profileKey);
            return Future.succeededFuture((Object)permissions);
        });
    }

    static Future<Boolean> inspectAuthorized(Class<?> clazz, SAction action, JsonArray permission) {
        String permissionId = action.getPermissionId();
        if (Objects.nonNull(permissionId)) {
            if (permission.contains((Object)permissionId)) {
                Sc.debugCredit(LOGGER, "5. Accredit authorized ( permission = {0} ).", permissionId);
                return Future.succeededFuture((Object)Boolean.TRUE);
            }
            _403PermissionLimitException error = new _403PermissionLimitException(clazz, action.getCode(), permissionId);
            return Future.failedFuture((Throwable)((Object)error));
        }
        _500InternalServerException error = new _500InternalServerException(clazz, "Permission Id Null");
        return Future.failedFuture((Throwable)error);
    }

    static Future<JsonObject> inspectBound(DataBound bound, ScRequest request) {
        JsonObject data = bound.toJson();
        String cacheKey = request.getCacheKey();
        Sc.debugCredit(LOGGER, "6. Accredit bound ( bound = {0} and key = {1} )", data.encode(), cacheKey);
        return request.openSession().compose(privilege -> privilege.storedBound(cacheKey, data));
    }

    static Future<Boolean> inspectAuthorized(ScRequest request) {
        String authorizedKey = request.getAuthorizedKey();
        Sc.debugCredit(LOGGER, "7. Accredit authorized cache ( key = {0} ) stored into ( session = {1} )", authorizedKey, request.getSessionId());
        return request.openSession().compose(privilege -> privilege.storedAuthorized(authorizedKey, Boolean.TRUE));
    }
}

