/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.permission;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.rbac.permission.ScHabitus;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public class ScPrivilege
implements Serializable {
    private final transient String habitusId;
    private transient ScHabitus habitus;

    private ScPrivilege(String habitusId) {
        this.habitusId = habitusId;
    }

    public static Future<ScPrivilege> init(JsonObject data) {
        String habitusId = data.getString("habitus");
        return new ScPrivilege(habitusId).open().compose(self -> {
            ScHabitus habitus = self.habitus;
            return habitus.set("user", data.getString("user")).compose(nil -> habitus.set("role", data.getJsonArray("role"))).compose(nil -> habitus.set("group", data.getJsonArray("group"))).compose(nil -> Ux.future((Object)self));
        });
    }

    public static Future<ScPrivilege> open(String habitusId) {
        return new ScPrivilege(habitusId).open();
    }

    private Future<ScPrivilege> open() {
        this.habitus = ScHabitus.initialize(this.habitusId);
        return Future.succeededFuture((Object)this);
    }

    public Future<Boolean> evaluate(Function<JsonObject, Future<Boolean>> fnDirect) {
        return this.fetchProfile().compose(profile -> Ut.isNil((JsonObject)profile) ? (Future)fnDirect.apply((JsonObject)profile) : Future.succeededFuture((Object)Boolean.TRUE));
    }

    private Future<JsonObject> fetchProfile() {
        return this.habitus.get("profile").compose(Ke.Result::jsonAsync);
    }

    public Future<JsonObject> storeProfile(JsonObject profiles) {
        return this.habitus.set("profile", profiles);
    }

    public Future<JsonArray> fetchPermissions(String profileKey) {
        return this.fetchProfile().compose(this.extractAsync(profileKey, "PERM"));
    }

    public Future<JsonArray> fetchRoles(String profileKey) {
        return this.fetchProfile().compose(this.extractAsync(profileKey, "ROLE"));
    }

    public Future<Boolean> fetchAuthorized(String authorizeKey) {
        return this.habitus.get(authorizeKey).compose(result -> Objects.isNull(result) ? Future.succeededFuture((Object)Boolean.FALSE) : Future.succeededFuture((Object)result));
    }

    public Future<JsonObject> storedBound(String key, JsonObject data) {
        return this.habitus.set(key, data);
    }

    public Future<Boolean> storedAuthorized(String key, Boolean result) {
        return this.habitus.set(key, result);
    }

    public Future<Boolean> clear() {
        return this.habitus.clear();
    }

    private Function<JsonObject, Future<JsonArray>> extractAsync(String profileKey, String hitKey) {
        return profile -> {
            JsonArray value;
            JsonObject single = profile.getJsonObject(profileKey);
            if (Ut.isNil((JsonObject)single)) {
                single = new JsonObject();
            }
            if (Objects.isNull(value = single.getJsonArray(hitKey))) {
                value = new JsonArray();
            }
            return Ux.future((Object)value);
        };
    }
}

