/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.rbac.permission;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxPool;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ScHabitus {
    private static final Annal LOGGER = Annal.get(ScHabitus.class);
    private static final String POOL_HABITUS = "vertx-web.sessions.habitus";
    private static final ConcurrentMap<String, ScHabitus> POOLS = new ConcurrentHashMap<String, ScHabitus>();
    private final transient UxPool pool;
    private final transient String habitus;

    private ScHabitus(String habitus) {
        Sc.infoResource(LOGGER, "Pool = {0} has been initialized to `habitus` = {1}", POOL_HABITUS, habitus);
        this.habitus = habitus;
        this.pool = Ux.Pool.on((String)POOL_HABITUS);
    }

    public static ScHabitus initialize(String habitus) {
        return (ScHabitus)Fn.pool(POOLS, (Object)habitus, () -> new ScHabitus(habitus));
    }

    public <T> Future<T> get(String dataKey) {
        return this.pool.get((Object)this.habitus).compose(item -> {
            if (Objects.isNull(item)) {
                return Future.succeededFuture(null);
            }
            return Ux.future((Object)item.getValue(dataKey));
        });
    }

    public <T> Future<T> set(String dataKey, T value) {
        return this.pool.get((Object)this.habitus).compose(stored -> {
            if (Ut.isNil((JsonObject)stored)) {
                stored = new JsonObject();
            }
            JsonObject updated = stored.copy();
            updated.put(dataKey, value);
            return this.pool.put((Object)this.habitus, (Object)updated).compose(nil -> Ux.future((Object)value));
        });
    }

    public Future<Boolean> clear() {
        POOLS.remove(this.habitus);
        return this.pool.remove((Object)this.habitus).compose(kv -> Future.succeededFuture((Object)Boolean.TRUE));
    }
}

