/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.view;

import cn.vertxup.rbac.domain.tables.daos.SViewDao;
import cn.vertxup.rbac.domain.tables.pojos.SView;
import cn.vertxup.rbac.service.view.ViewStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.cv.em.OwnerType;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.UUID;

public class ViewService
implements ViewStub {
    private static final Annal LOGGER = Annal.get(ViewService.class);

    @Override
    public Future<SView> fetchMatrix(String userId, String resourceId, String view) {
        JsonObject filters = this.toFilters(resourceId, view);
        filters.put("owner", userId);
        filters.put("ownerType", OwnerType.USER.name());
        Sc.infoResource(LOGGER, "My View Operation: {0}, filters = {1}", "fetch", filters.encode());
        return Ux.Jooq.on(SViewDao.class).fetchOneAsync(new JsonObject().put("criteria", filters));
    }

    @Override
    public Future<SView> saveMatrix(String userId, String resourceId, String view, JsonArray projection) {
        JsonObject filters = this.toFilters(resourceId, view);
        filters.put("owner", userId);
        filters.put("ownerType", OwnerType.USER.name());
        Sc.infoResource(LOGGER, "My View Operation: {0}, filters = {1}", "save", filters.encode());
        SView myView = this.toView(filters, projection);
        return Ux.Jooq.on(SViewDao.class).upsertAsync(filters, (Object)myView);
    }

    @Override
    public Future<List<SView>> fetchMatrix(JsonArray roleIds, String resourceId, String view) {
        JsonObject filters = this.toFilters(resourceId, view);
        filters.put("owner,i", roleIds);
        filters.put("ownerType", OwnerType.ROLE.name());
        return Ux.Jooq.on(SViewDao.class).fetchAndAsync(new JsonObject().put("criteria", filters));
    }

    private JsonObject toFilters(String resourceId, String view) {
        JsonObject filters = new JsonObject();
        filters.put("", Boolean.TRUE);
        filters.put("resourceId", resourceId);
        filters.put("name", view);
        return filters;
    }

    private SView toView(JsonObject filters, JsonArray projection) {
        JsonObject data = filters.copy().put("projection", projection.encode());
        data.put("key", UUID.randomUUID().toString());
        data.put("active", Boolean.TRUE);
        data.put("rows", new JsonObject().encode());
        data.put("criteria", new JsonObject().encode());
        return (SView)Ut.deserialize((JsonObject)data, SView.class);
    }
}

