/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.batch;

import cn.vertxup.rbac.domain.tables.daos.OUserDao;
import cn.vertxup.rbac.domain.tables.daos.SUserDao;
import cn.vertxup.rbac.domain.tables.pojos.OUser;
import cn.vertxup.rbac.domain.tables.pojos.SRole;
import cn.vertxup.rbac.domain.tables.pojos.SUser;
import cn.vertxup.rbac.service.batch.AbstractIdc;
import cn.vertxup.rbac.service.batch.IdcRole;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._403TokenGenerationException;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.record.Atomy;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

class IdcService
extends AbstractIdc {
    IdcService(String sigma) {
        super(sigma);
    }

    @Override
    public Future<JsonArray> saveAsync(JsonArray user, String by) {
        Refer dataArray = new Refer();
        Refer roleRef = new Refer();
        return this.runPre(user).compose(arg_0 -> ((Refer)dataArray).future(arg_0)).compose(nil -> IdcRole.create(this.sigma).fetchAsync()).compose(arg_0 -> ((Refer)roleRef).future(arg_0)).compose(verified -> {
            JsonArray filtered = new JsonArray();
            HashSet nameSet = new HashSet();
            Ut.itJArray((JsonArray)user).forEach(each -> {
                if (!nameSet.contains(each.getString("username"))) {
                    filtered.add(each);
                    nameSet.add("username");
                } else {
                    Sc.infoWeb(this.getClass(), "User ( username = {0} ) duplicated and will be ignored: {1}", each.getString("username"), each.encode());
                }
            });
            JsonObject condition = new JsonObject();
            condition.put("username,i", Ut.toJArray((Set)Ut.mapString((JsonArray)filtered, (String)"username")));
            condition.put("sigma", this.sigma);
            condition.put("", Boolean.TRUE);
            Sc.infoWeb(this.getClass(), "Unique filters: {0}", condition.encode());
            return Ux.Jooq.on(SUserDao.class).findAsync(condition).compose(Ux::fnJArray).compose(original -> {
                Atomy atomy = Atomy.create((JsonArray)original, (JsonArray)filtered);
                Atomy created = Ke.compmared((Atomy)atomy, (String)"username", (String)by);
                ConcurrentMap<String, List<SRole>> roleMap = IdcRole.create(this.sigma).toMap((JsonArray)dataArray.get(), (List)roleRef.get());
                return (Future)Ke.atomyFn(this.getClass(), (Atomy)created).apply(inserted -> this.createAsync((JsonArray)inserted, roleMap), updated -> this.updateAsync((JsonArray)updated, roleMap));
            });
        });
    }

    private Future<JsonArray> createAsync(JsonArray userJson, ConcurrentMap<String, List<SRole>> roleMap) {
        return this.model(userJson).compose(processed -> {
            List users = Ux.fromJson((JsonArray)processed, SUser.class);
            users.forEach(user -> {
                user.setKey(UUID.randomUUID().toString());
                user.setActive(Boolean.TRUE);
                user.setPassword("25D55AD283AA400AF464C76D713C07AD");
                user.setSigma(this.sigma);
                user.setLanguage("cn");
            });
            return Ux.Jooq.on(SUserDao.class).insertAsync(users).compose(this::createToken).compose(updated -> IdcRole.create(this.sigma).saveRel((List<SUser>)updated, roleMap));
        });
    }

    private Future<List<SUser>> createToken(List<SUser> users) {
        if (users.isEmpty()) {
            return Ux.future(new ArrayList());
        }
        Set sigmaSet = users.stream().map(SUser::getSigma).collect(Collectors.toSet());
        if (sigmaSet.size() == 1) {
            return this.credential(() -> Ux.future((Object)users), credential -> {
                ArrayList ousers = new ArrayList();
                users.stream().map(user -> new OUser().setActive(Boolean.TRUE).setKey(UUID.randomUUID().toString()).setClientId(user.getKey()).setClientSecret(Ut.randomString((int)64)).setScope(credential.getRealm()).setLanguage(user.getLanguage()).setGrantType(credential.getGrantType())).forEach(ousers::add);
                return Ux.Jooq.on(OUserDao.class).insertAsync(ousers).compose(created -> Ux.future((Object)users));
            });
        }
        return Future.failedFuture((Throwable)new _403TokenGenerationException(this.getClass(), Integer.valueOf(sigmaSet.size())));
    }

    private Future<JsonArray> updateAsync(JsonArray userJson, ConcurrentMap<String, List<SRole>> roleMap) {
        List users = Ux.fromJson((JsonArray)userJson, SUser.class);
        users.forEach(user -> user.setActive(Boolean.TRUE));
        return Ux.Jooq.on(SUserDao.class).updateAsync(users).compose(updated -> IdcRole.create(this.sigma).saveRel((List<SUser>)updated, roleMap));
    }
}

