/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.rbac.service.batch;

import cn.vertxup.rbac.domain.tables.daos.RUserRoleDao;
import cn.vertxup.rbac.domain.tables.daos.SRoleDao;
import cn.vertxup.rbac.domain.tables.pojos.RUserRole;
import cn.vertxup.rbac.domain.tables.pojos.SRole;
import cn.vertxup.rbac.domain.tables.pojos.SUser;
import cn.vertxup.rbac.service.batch.Pool;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.rbac.refine.Sc;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

class IdcRole {
    private final transient String sigma;

    private IdcRole(String sigma) {
        this.sigma = sigma;
    }

    static IdcRole create(String sigma) {
        return (IdcRole)Fn.pool(Pool.ROLE, (Object)sigma, () -> new IdcRole(sigma));
    }

    Future<List<SRole>> fetchAsync() {
        return Ux.Jooq.on(SRoleDao.class).fetchAsync("sigma", (Object)this.sigma);
    }

    ConcurrentMap<String, List<SRole>> toMap(JsonArray users, List<SRole> roles) {
        ConcurrentHashMap<String, List<SRole>> roleMap = new ConcurrentHashMap<String, List<SRole>>();
        if (Objects.nonNull(users)) {
            ConcurrentHashMap grouped = new ConcurrentHashMap();
            roles.stream().filter(Objects::nonNull).forEach(role -> grouped.put(role.getName(), role.getKey()));
            Ut.itJArray((JsonArray)users).forEach(user -> {
                String roleNames = user.getString("roles");
                if (Ut.notNil((String)roleNames)) {
                    List validRoles = Arrays.stream(roleNames.split(",")).map(String::trim).filter(Ut::notNil).filter(grouped::containsKey).collect(Collectors.toList());
                    String username = user.getString("username");
                    List roleList = roles.stream().filter(Objects::nonNull).filter(role -> validRoles.contains(role.getName())).collect(Collectors.toList());
                    roleMap.put(username, roleList);
                }
            });
        }
        return roleMap;
    }

    public Future<JsonArray> saveRel(List<SUser> users, ConcurrentMap<String, List<SRole>> roleMap) {
        if (users.isEmpty()) {
            return Ux.future((Object)new JsonArray());
        }
        Set userKeys = users.stream().map(SUser::getKey).collect(Collectors.toSet());
        JsonObject condition = new JsonObject();
        condition.put("userId,i", Ut.toJArray(userKeys));
        return Ux.Jooq.on(RUserRoleDao.class).deleteAsync(condition).compose(deleted -> {
            ArrayList relationList = new ArrayList();
            users.forEach(user -> {
                List roles = (List)roleMap.get(user.getUsername());
                Ut.itList((List)roles, (role, index) -> {
                    RUserRole relation = new RUserRole();
                    relation.setRoleId(role.getKey());
                    relation.setUserId(user.getKey());
                    relation.setPriority((Integer)index);
                    relationList.add(relation);
                });
                Sc.infoWeb(this.getClass(), "Will build username = {1}, role size = {0}", String.valueOf(roles.size()), user.getUsername());
            });
            return Ux.Jooq.on(RUserRoleDao.class).insertAsync(relationList).compose(inserted -> Ux.future((Object)users)).compose(Ux::fnJArray);
        });
    }
}

