/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic;

import io.vertx.tp.optic.Income;
import io.vertx.tp.optic.Lexeme;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Pocket {
    private static final ConcurrentMap<String, Object> REF = new ConcurrentHashMap<String, Object>();

    public static <T> Lexeme<T> get(Class<T> interfaceCls) {
        Object reference;
        if (Objects.isNull(interfaceCls)) {
            return null;
        }
        String cacheKey = interfaceCls.getName();
        Lexeme<Object> found = REF.getOrDefault(cacheKey, null);
        if (Objects.isNull(found) && Objects.nonNull(reference = Ut.service(interfaceCls))) {
            found = new Lexeme<Object>(interfaceCls, reference);
            REF.put(cacheKey, found);
        }
        return found;
    }

    public static <T> T lookup(Class<T> clazz) {
        Lexeme<T> lexeme = Pocket.get(clazz);
        if (Objects.isNull(lexeme)) {
            return null;
        }
        return lexeme.instance();
    }

    public static <T> Income income(Class<T> clazz, Object ... args) {
        Income income = Income.in(clazz);
        for (Object arg : args) {
            income.in(arg);
        }
        return income;
    }
}

