/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic;

import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class Lexeme<T>
implements Serializable {
    private final transient List<String> params = new ArrayList<String>();
    private final transient Class<?> interfaceCls;
    private final transient T reference;

    public Lexeme(Class<?> interfaceCls, T reference) {
        this.interfaceCls = interfaceCls;
        this.reference = reference;
        this.parseParams(interfaceCls);
    }

    private void parseParams(Class<?> interfaceCls) {
        Field[] constants = interfaceCls.getDeclaredFields();
        TreeSet fieldSet = new TreeSet();
        Arrays.stream(constants).map(Field::getName).filter(item -> item.startsWith("ARG")).forEach(fieldSet::add);
        fieldSet.forEach(field -> {
            Object value = Ut.field((Class)interfaceCls, (String)field);
            this.params.add((String)value);
        });
    }

    public T instance() {
        return this.reference;
    }

    public Class<?> clazz() {
        return this.interfaceCls;
    }

    public List<String> params() {
        return this.params;
    }
}

