/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.up.atom.pojo.Mirror;
import io.vertx.up.atom.pojo.Mojo;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class KeUser {
    private static final Set<String> FIELDS = new HashSet<String>(){
        {
            this.add("sigma");
            this.add("language");
            this.add("active");
            this.add("createdAt");
            this.add("createdBy");
            this.add("updatedAt");
            this.add("updatedBy");
        }
    };

    KeUser() {
    }

    static <T, I> void audit(I output, String outPojo, T input, String inPojo, boolean isUpdated) {
        ConcurrentMap<String, String> outMap = KeUser.buildMap(outPojo, isUpdated);
        ConcurrentMap<String, String> inMap = KeUser.buildMap(inPojo, isUpdated);
        LocalDateTime now = LocalDateTime.now();
        outMap.forEach((key, out) -> {
            String in = (String)inMap.get(key);
            if ("createdAt".equals(in) || "updatedAt".equals(in)) {
                Ut.field((Object)output, (String)out, (Object)now);
            } else {
                Ut.field((Object)output, (String)out, (Object)Ut.field((Object)input, (String)in));
            }
        });
    }

    private static ConcurrentMap<String, String> buildMap(String filename, boolean isUpdated) {
        ConcurrentHashMap<String, String> vector = new ConcurrentHashMap<String, String>();
        if (Ut.isNil((String)filename)) {
            FIELDS.forEach(each -> vector.put((String)each, (String)each));
        } else {
            Mojo outMojo = Mirror.create(KeUser.class).mount(filename).mojo();
            outMojo.getIn().forEach((in, out) -> {
                if (FIELDS.contains(in)) {
                    vector.put((String)in, (String)out);
                }
            });
        }
        if (isUpdated) {
            vector.remove("createdBy");
            vector.remove("createdAt");
        }
        return vector;
    }
}

