/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.KeLog;
import io.vertx.tp.ke.refine.KeRun;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.config.Database;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jooq.Configuration;

class KeTool {
    private static final Node<JsonObject> VISITOR = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static String DATABASE;

    KeTool() {
    }

    static String getCatalog() {
        if (Ut.isNil((String)DATABASE)) {
            JsonObject config = (JsonObject)VISITOR.read();
            DATABASE = Ut.visitString((JsonObject)config, (String[])new String[]{"jooq", "provider", "catalog"});
        }
        return DATABASE;
    }

    static Configuration getConfiguration() {
        Database database = Database.getCurrent();
        DataPool pool = DataPool.create((Database)database);
        return pool.getExecutor().configuration();
    }

    static Future<JsonObject> map(JsonObject data, String field, ConcurrentMap<String, JsonObject> attachmentMap, BiFunction<JsonObject, JsonArray, Future<JsonArray>> fileFn) {
        String key = data.getString(field);
        Objects.requireNonNull(key);
        ConcurrentHashMap futures = new ConcurrentHashMap();
        attachmentMap.forEach((fieldF, condition) -> {
            JsonObject criteria = condition.copy();
            if (Ut.notNil((JsonObject)criteria)) {
                criteria.put("", (Object)Boolean.TRUE);
                criteria.put("modelKey", (Object)key);
                JsonArray dataArray = Ut.valueJArray((JsonObject)data, (String)fieldF);
                Ut.itJArray((JsonArray)dataArray).forEach(json -> json.put("modelKey", (Object)key));
                futures.put(fieldF, (Future)fileFn.apply(criteria, dataArray));
            } else {
                KeLog.warnChannel(KeRun.class, "Criteria must be not empty", new Object[0]);
            }
        });
        return Ux.thenCombine(futures).compose(mapData -> {
            mapData.forEach((arg_0, arg_1) -> ((JsonObject)data).put(arg_0, arg_1));
            return Ux.future((Object)data);
        });
    }

    static <T> void consume(Supplier<T> supplier, Consumer<T> consumer) {
        T input = supplier.get();
        if (Objects.nonNull(input)) {
            if (input instanceof String) {
                if (Ut.notNil((String)((String)input))) {
                    consumer.accept(input);
                }
            } else {
                consumer.accept(input);
            }
        }
    }

    static void banner(String module) {
        System.out.println("-------------------------------------------------------------");
        System.out.println("|                                                           |");
        System.out.println("|     Zero Extension:  " + module);
        System.out.println("|                                                           |");
        System.out.println("-------------------------------------------------------------");
    }
}

